
---------------------------------------------
-- Style Definition
---------------------------------------------

local LSM = LibStub("LibSharedMedia-3.0")

LSM:Register("font", "文泉驿微米黑", [[Interface\AddOns\TidyPlates_Neon_CN\wqy-microhei.origin.ttf]], LSM.LOCALE_BIT_zhCN)
LSM:Register("font", "文泉驿微米黑(改)", [[Interface\AddOns\TidyPlates_Neon_CN\wqy-microhei.fixed.ttf]], LSM.LOCALE_BIT_zhCN)

local font = LSM:Fetch("font", "文泉驿微米黑(改)")
local fontsize = 12
local padding = 6

---------------------------------------------
-- Copy Theme
---------------------------------------------

local CopyTable = TidyPlatesUtility.copyTable

local theme = CopyTable(TidyPlatesThemeList["Neon"])

---------------------------------------------
-- Default Style
---------------------------------------------

local StyleDefault = theme["Default"]

StyleDefault.name.typeface = font
StyleDefault.name.size = fontsize
StyleDefault.name.y = StyleDefault.name.y - padding

StyleDefault.customtext.typeface = font
StyleDefault.customtext.size = fontsize - 2

StyleDefault.castborder.y = StyleDefault.castborder.y - padding
StyleDefault.castnostop.y = StyleDefault.castnostop.y - padding
StyleDefault.castbar.y = StyleDefault.castbar.y - padding
StyleDefault.spellicon.y = StyleDefault.spellicon.y - padding
StyleDefault.spellicon.width = 18
StyleDefault.spellicon.height = 20
StyleDefault.spellicon.height = StyleDefault.spellicon.height + .8
StyleDefault.spelltext.y = StyleDefault.spelltext.y - padding * 2 + 3
StyleDefault.spelltext.typeface = font
StyleDefault.spelltext.size = fontsize



---------------------------------------------
-- Name-Only Style
---------------------------------------------

local StyleTextOnly = theme["NameOnly"]

StyleTextOnly.target.height = StyleTextOnly.target.height + 10
StyleTextOnly.target.y = StyleTextOnly.target.y - 5

StyleTextOnly.name.typeface = font
StyleTextOnly.name.size = fontsize

StyleTextOnly.customtext.typeface = font
StyleTextOnly.customtext.size = fontsize - 2
StyleTextOnly.customtext.y = StyleTextOnly.customtext.y - 4

StyleTextOnly.spellicon.width = 18
StyleTextOnly.spellicon.height = 20
StyleTextOnly.spellicon.height = StyleTextOnly.spellicon.height + .8
StyleTextOnly.spelltext.typeface = font
StyleTextOnly.spelltext.size = fontsize



---------------------------------------------
-- Tidy Plates Hub Integration
---------------------------------------------

TidyPlatesThemeList["Neon CN"] = theme
TidyPlatesHubFunctions.ApplyHubFunctions(theme)
