/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreVendor;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.net.SSLContext;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtilBase;
import org.apache.tomcat.util.net.jsse.JSSEKeyManager;
import org.apache.tomcat.util.net.jsse.JSSESSLContext;
import org.apache.tomcat.util.net.jsse.PEMFile;
import org.apache.tomcat.util.res.StringManager;

public class JSSEUtil
extends SSLUtilBase {
    private static final Log log;
    private static final StringManager sm;
    private static final Set<String> implementedProtocols;
    private static final Set<String> implementedCiphers;
    private final SSLHostConfig sslHostConfig;

    public JSSEUtil(SSLHostConfigCertificate certificate) {
        super(certificate);
        this.sslHostConfig = certificate.getSSLHostConfig();
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Set<String> getImplementedProtocols() {
        return implementedProtocols;
    }

    @Override
    protected Set<String> getImplementedCiphers() {
        return implementedCiphers;
    }

    @Override
    public SSLContext createSSLContext(List<String> negotiableProtocols) throws NoSuchAlgorithmException {
        return new JSSESSLContext(this.sslHostConfig.getSslProtocol());
    }

    @Override
    public KeyManager[] getKeyManagers() throws Exception {
        String keystoreType = this.certificate.getCertificateKeystoreType();
        String keyAlias = this.certificate.getCertificateKeyAlias();
        String algorithm = this.sslHostConfig.getKeyManagerAlgorithm();
        String keyPass = this.certificate.getCertificateKeyPassword();
        if (keyPass == null) {
            keyPass = this.certificate.getCertificateKeystorePassword();
        }
        KeyManager[] kms = null;
        KeyStore ks = this.certificate.getCertificateKeystore();
        if (ks == null) {
            ks = KeyStore.getInstance("JKS");
            ks.load(null, null);
            PEMFile privateKeyFile = new PEMFile(SSLHostConfig.adjustRelativePath(this.certificate.getCertificateKeyFile() != null ? this.certificate.getCertificateKeyFile() : this.certificate.getCertificateFile()), keyPass);
            PEMFile certificateFile = new PEMFile(SSLHostConfig.adjustRelativePath(this.certificate.getCertificateFile()));
            ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
            chain.addAll(certificateFile.getCertificates());
            if (this.certificate.getCertificateChainFile() != null) {
                PEMFile certificateChainFile = new PEMFile(SSLHostConfig.adjustRelativePath(this.certificate.getCertificateChainFile()));
                chain.addAll(certificateChainFile.getCertificates());
            }
            ks.setKeyEntry(keyAlias, privateKeyFile.getPrivateKey(), keyPass.toCharArray(), chain.toArray(new Certificate[chain.size()]));
        }
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            throw new IOException(sm.getString("jsse.alias_no_key_entry", new Object[]{keyAlias}));
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keyPass.toCharArray());
        kms = kmf.getKeyManagers();
        if (kms == null) {
            return kms;
        }
        if (keyAlias != null) {
            String alias = keyAlias;
            if ("JKS".equals(keystoreType)) {
                alias = alias.toLowerCase(Locale.ENGLISH);
            }
            for (int i = 0; i < kms.length; ++i) {
                kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], alias);
            }
        }
        return kms;
    }

    @Override
    public TrustManager[] getTrustManagers() throws Exception {
        String algorithm = this.sslHostConfig.getTruststoreAlgorithm();
        String crlf = this.sslHostConfig.getCertificateRevocationListFile();
        String className = this.sslHostConfig.getTrustManagerClassName();
        if (className != null && className.length() > 0) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> clazz = classLoader.loadClass(className);
            if (!TrustManager.class.isAssignableFrom(clazz)) {
                throw new InstantiationException(sm.getString("jsse.invalidTrustManagerClassName", new Object[]{className}));
            }
            Object trustManagerObject = clazz.newInstance();
            TrustManager trustManager = (TrustManager)trustManagerObject;
            return new TrustManager[]{trustManager};
        }
        TrustManager[] tms = null;
        KeyStore trustStore = this.sslHostConfig.getTruststore();
        if (trustStore != null || className != null) {
            if (crlf == null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(trustStore);
                tms = tmf.getTrustManagers();
            } else {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                CertPathParameters params = this.getParameters(algorithm, crlf, trustStore);
                CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
                tmf.init(mfp);
                tms = tmf.getTrustManagers();
            }
        }
        return tms;
    }

    @Override
    public void configureSessionContext(SSLSessionContext sslSessionContext) {
        sslSessionContext.setSessionCacheSize(this.sslHostConfig.getSessionCacheSize());
        sslSessionContext.setSessionTimeout(this.sslHostConfig.getSessionTimeout());
    }

    protected CertPathParameters getParameters(String algorithm, String crlf, KeyStore trustStore) throws Exception {
        if ("PKIX".equalsIgnoreCase(algorithm)) {
            PKIXBuilderParameters xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            Collection<? extends CRL> crls = this.getCRLs(crlf);
            CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
            CertStore store = CertStore.getInstance("Collection", csp);
            xparams.addCertStore(store);
            xparams.setRevocationEnabled(true);
            xparams.setMaxPathLength(this.sslHostConfig.getCertificateVerificationDepth());
            return xparams;
        }
        throw new CRLException("CRLs not supported for type: " + algorithm);
    }

    protected Collection<? extends CRL> getCRLs(String crlf) throws IOException, CRLException, CertificateException {
        Collection<? extends CRL> crls = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            try (InputStream is = ConfigFileLoader.getInputStream((String)crlf);){
                crls = cf.generateCRLs(is);
            }
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (CRLException crle) {
            throw crle;
        }
        catch (CertificateException ce) {
            throw ce;
        }
        return crls;
    }

    static {
        JSSESSLContext context;
        log = LogFactory.getLog(JSSEUtil.class);
        sm = StringManager.getManager(JSSEUtil.class);
        try {
            context = new JSSESSLContext("TLS");
            context.init(null, null, null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
        SSLServerSocketFactory ssf = context.getServerSocketFactory();
        implementedProtocols = new HashSet<String>();
        try {
            String[] stringArray = null;
            try (SSLServerSocket socket = (SSLServerSocket)ssf.createServerSocket();){
                String[] stringArray2 = socket.getEnabledProtocols();
                int n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String protocol = stringArray2[i];
                    String protocolUpper = protocol.toUpperCase(Locale.ENGLISH);
                    if (!"SSLV2HELLO".equals(protocolUpper) && protocolUpper.contains("SSL")) {
                        log.debug((Object)sm.getString("jsse.excludeDefaultProtocol", new Object[]{protocol}));
                        continue;
                    }
                    implementedProtocols.add(protocol);
                }
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
        }
        catch (IOException socket) {
            // empty catch block
        }
        if (implementedProtocols.size() == 0) {
            log.warn((Object)sm.getString("jsse.noDefaultProtocols"));
        }
        String[] implementedCipherSuiteArray = context.getSupportedSSLParameters().getCipherSuites();
        if (JreVendor.IS_IBM_JVM) {
            implementedCiphers = new HashSet<String>(implementedCipherSuiteArray.length * 2);
            for (String name : implementedCipherSuiteArray) {
                implementedCiphers.add(name);
                if (!name.startsWith("SSL")) continue;
                implementedCiphers.add("TLS" + name.substring(3));
            }
        } else {
            implementedCiphers = new HashSet<String>(implementedCipherSuiteArray.length);
            implementedCiphers.addAll(Arrays.asList(implementedCipherSuiteArray));
        }
    }
}

