/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import org.apache.coyote.ActionCode;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.HeadersTooLargeException;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class Http11OutputBuffer
implements OutputBuffer {
    protected static final StringManager sm = StringManager.getManager(Http11OutputBuffer.class);
    private static final Log log = LogFactory.getLog(Http11OutputBuffer.class);
    protected final Response response;
    protected boolean finished;
    protected final byte[] headerBuffer;
    protected int pos;
    protected OutputFilter[] filterLibrary;
    protected OutputFilter[] activeFilters;
    protected int lastActiveFilter;
    protected OutputBuffer outputStreamOutputBuffer;
    protected SocketWrapperBase<?> socketWrapper;
    protected long byteCount = 0L;

    protected Http11OutputBuffer(Response response, int headerBufferSize) {
        this.response = response;
        this.headerBuffer = new byte[headerBufferSize];
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.finished = false;
        this.outputStreamOutputBuffer = new SocketOutputBuffer();
    }

    public void addFilter(OutputFilter filter) {
        OutputFilter[] newFilterLibrary = new OutputFilter[this.filterLibrary.length + 1];
        for (int i = 0; i < this.filterLibrary.length; ++i) {
            newFilterLibrary[i] = this.filterLibrary[i];
        }
        newFilterLibrary[this.filterLibrary.length] = filter;
        this.filterLibrary = newFilterLibrary;
        this.activeFilters = new OutputFilter[this.filterLibrary.length];
    }

    public OutputFilter[] getFilters() {
        return this.filterLibrary;
    }

    public void addActiveFilter(OutputFilter filter) {
        if (this.lastActiveFilter == -1) {
            filter.setBuffer(this.outputStreamOutputBuffer);
        } else {
            for (int i = 0; i <= this.lastActiveFilter; ++i) {
                if (this.activeFilters[i] != filter) continue;
                return;
            }
            filter.setBuffer(this.activeFilters[this.lastActiveFilter]);
        }
        this.activeFilters[++this.lastActiveFilter] = filter;
        filter.setResponse(this.response);
    }

    @Override
    public int doWrite(ByteChunk chunk) throws IOException {
        if (!this.response.isCommitted()) {
            this.response.action(ActionCode.COMMIT, null);
        }
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.doWrite(chunk);
        }
        return this.activeFilters[this.lastActiveFilter].doWrite(chunk);
    }

    @Override
    public long getBytesWritten() {
        if (this.lastActiveFilter == -1) {
            return this.outputStreamOutputBuffer.getBytesWritten();
        }
        return this.activeFilters[this.lastActiveFilter].getBytesWritten();
    }

    public void flush() throws IOException {
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            if (!(this.activeFilters[i] instanceof GzipOutputFilter)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Flushing the gzip filter at position " + i + " of the filter chain..."));
            }
            ((GzipOutputFilter)this.activeFilters[i]).flush();
            break;
        }
        this.flushBuffer(this.isBlocking());
    }

    public void reset() {
        if (this.response.isCommitted()) {
            throw new IllegalStateException(sm.getString("iob.illegalreset"));
        }
        this.pos = 0;
        this.byteCount = 0L;
    }

    public void recycle() {
        this.nextRequest();
        this.socketWrapper = null;
    }

    public void nextRequest() {
        for (int i = 0; i <= this.lastActiveFilter; ++i) {
            this.activeFilters[i].recycle();
        }
        this.response.recycle();
        this.pos = 0;
        this.lastActiveFilter = -1;
        this.finished = false;
        this.byteCount = 0L;
    }

    public void endRequest() throws IOException {
        if (this.finished) {
            return;
        }
        if (this.lastActiveFilter != -1) {
            this.activeFilters[this.lastActiveFilter].end();
        }
        this.flushBuffer(true);
        this.finished = true;
    }

    public void init(SocketWrapperBase<?> socketWrapper) {
        this.socketWrapper = socketWrapper;
    }

    public void sendAck() throws IOException {
        if (!this.response.isCommitted()) {
            this.socketWrapper.write(this.isBlocking(), Constants.ACK_BYTES, 0, Constants.ACK_BYTES.length);
            if (this.flushBuffer(true)) {
                throw new IOException(sm.getString("iob.failedwrite.ack"));
            }
        }
    }

    protected void commit() throws IOException {
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.socketWrapper.write(this.isBlocking(), this.headerBuffer, 0, this.pos);
        }
    }

    public void sendStatus() {
        this.write(Constants.HTTP_11_BYTES);
        this.headerBuffer[this.pos++] = 32;
        int status = this.response.getStatus();
        switch (status) {
            case 200: {
                this.write(Constants._200_BYTES);
                break;
            }
            case 400: {
                this.write(Constants._400_BYTES);
                break;
            }
            case 404: {
                this.write(Constants._404_BYTES);
                break;
            }
            default: {
                this.write(String.valueOf(status));
            }
        }
        this.headerBuffer[this.pos++] = 32;
        this.headerBuffer[this.pos++] = 13;
        this.headerBuffer[this.pos++] = 10;
    }

    public void sendHeader(MessageBytes name, MessageBytes value) {
        this.write(name);
        this.headerBuffer[this.pos++] = 58;
        this.headerBuffer[this.pos++] = 32;
        this.write(value);
        this.headerBuffer[this.pos++] = 13;
        this.headerBuffer[this.pos++] = 10;
    }

    public void endHeaders() {
        this.headerBuffer[this.pos++] = 13;
        this.headerBuffer[this.pos++] = 10;
    }

    private void write(MessageBytes mb) {
        if (mb.getType() != 2) {
            mb.toBytes();
            ByteChunk bc = mb.getByteChunk();
            byte[] buffer = bc.getBuffer();
            for (int i = bc.getOffset(); i < bc.getLength(); ++i) {
                if ((buffer[i] <= -1 || buffer[i] > 31 || buffer[i] == 9) && buffer[i] != 127) continue;
                buffer[i] = 32;
            }
        }
        this.write(mb.getByteChunk());
    }

    private void write(ByteChunk bc) {
        int length = bc.getLength();
        this.checkLengthBeforeWrite(length);
        System.arraycopy(bc.getBytes(), bc.getStart(), this.headerBuffer, this.pos, length);
        this.pos += length;
    }

    public void write(byte[] b) {
        this.checkLengthBeforeWrite(b.length);
        System.arraycopy(b, 0, this.headerBuffer, this.pos, b.length);
        this.pos += b.length;
    }

    private void write(String s) {
        if (s == null) {
            return;
        }
        int len = s.length();
        this.checkLengthBeforeWrite(len);
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c <= 31 && c != 9 || c == 127 || c > 255) {
                c = 32;
            }
            this.headerBuffer[this.pos++] = (byte)c;
        }
    }

    private void checkLengthBeforeWrite(int length) {
        if (this.pos + length + 4 > this.headerBuffer.length) {
            throw new HeadersTooLargeException(sm.getString("iob.responseheadertoolarge.error"));
        }
    }

    protected boolean flushBuffer(boolean block) throws IOException {
        return this.socketWrapper.flush(block);
    }

    protected final boolean isBlocking() {
        return this.response.getWriteListener() == null;
    }

    protected final boolean isReady() {
        boolean result;
        boolean bl = result = !this.hasDataToWrite();
        if (!result) {
            this.socketWrapper.registerWriteInterest();
        }
        return result;
    }

    public boolean hasDataToWrite() {
        return this.socketWrapper.hasDataToWrite();
    }

    public void registerWriteInterest() {
        this.socketWrapper.registerWriteInterest();
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk chunk) throws IOException {
            int len = chunk.getLength();
            int start = chunk.getStart();
            byte[] b = chunk.getBuffer();
            Http11OutputBuffer.this.socketWrapper.write(Http11OutputBuffer.this.isBlocking(), b, start, len);
            Http11OutputBuffer.this.byteCount += (long)len;
            return len;
        }

        @Override
        public long getBytesWritten() {
            return Http11OutputBuffer.this.byteCount;
        }
    }
}

