/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;
import java.sql.DriverManager;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.compat.JreVendor;
import org.apache.tomcat.util.res.StringManager;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;

public class JreMemoryLeakPreventionListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(JreMemoryLeakPreventionListener.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    private boolean awtThreadProtection = false;
    private boolean gcDaemonProtection = true;
    private boolean tokenPollerProtection = true;
    private boolean urlCacheProtection = true;
    private boolean xmlParsingProtection = true;
    private boolean ldapPoolProtection = true;
    private boolean driverManagerProtection = true;
    private String classesToInitialize = null;

    public boolean isAWTThreadProtection() {
        return this.awtThreadProtection;
    }

    public void setAWTThreadProtection(boolean awtThreadProtection) {
        this.awtThreadProtection = awtThreadProtection;
    }

    public boolean isGcDaemonProtection() {
        return this.gcDaemonProtection;
    }

    public void setGcDaemonProtection(boolean gcDaemonProtection) {
        this.gcDaemonProtection = gcDaemonProtection;
    }

    public boolean isTokenPollerProtection() {
        return this.tokenPollerProtection;
    }

    public void setTokenPollerProtection(boolean tokenPollerProtection) {
        this.tokenPollerProtection = tokenPollerProtection;
    }

    public boolean isUrlCacheProtection() {
        return this.urlCacheProtection;
    }

    public void setUrlCacheProtection(boolean urlCacheProtection) {
        this.urlCacheProtection = urlCacheProtection;
    }

    public boolean isXmlParsingProtection() {
        return this.xmlParsingProtection;
    }

    public void setXmlParsingProtection(boolean xmlParsingProtection) {
        this.xmlParsingProtection = xmlParsingProtection;
    }

    public boolean isLdapPoolProtection() {
        return this.ldapPoolProtection;
    }

    public void setLdapPoolProtection(boolean ldapPoolProtection) {
        this.ldapPoolProtection = ldapPoolProtection;
    }

    public boolean isDriverManagerProtection() {
        return this.driverManagerProtection;
    }

    public void setDriverManagerProtection(boolean driverManagerProtection) {
        this.driverManagerProtection = driverManagerProtection;
    }

    public String getClassesToInitialize() {
        return this.classesToInitialize;
    }

    public void setClassesToInitialize(String classesToInitialize) {
        this.classesToInitialize = classesToInitialize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_init".equals(event.getType())) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                if (this.driverManagerProtection) {
                    DriverManager.getDrivers();
                }
                if (this.awtThreadProtection) {
                    Toolkit.getDefaultToolkit();
                }
                if (this.gcDaemonProtection) {
                    try {
                        Class<?> clazz = Class.forName("sun.misc.GC");
                        Method method = clazz.getDeclaredMethod("requestLatency", Long.TYPE);
                        method.invoke(null, 0x7FFFFFFFFFFFFFFEL);
                    }
                    catch (ClassNotFoundException e) {
                        if (JreVendor.IS_ORACLE_JVM) {
                            log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                        } else {
                            log.debug((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                        log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        ExceptionUtils.handleThrowable((Throwable)e.getCause());
                        log.error((Object)sm.getString("jreLeakListener.gcDaemonFail"), (Throwable)e);
                    }
                }
                if (this.tokenPollerProtection) {
                    Security.getProviders();
                }
                if (this.urlCacheProtection) {
                    try {
                        URL url = new URL("jar:file://dummy.jar!/");
                        URLConnection uConn = url.openConnection();
                        uConn.setDefaultUseCaches(false);
                    }
                    catch (MalformedURLException e) {
                        log.error((Object)sm.getString("jreLeakListener.jarUrlConnCacheFail"), (Throwable)e);
                    }
                    catch (IOException e) {
                        log.error((Object)sm.getString("jreLeakListener.jarUrlConnCacheFail"), (Throwable)e);
                    }
                }
                if (this.xmlParsingProtection) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    try {
                        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
                        Document document = documentBuilder.newDocument();
                        document.createElement("dummy");
                        DOMImplementationLS implementation = (DOMImplementationLS)((Object)document.getImplementation());
                        implementation.createLSSerializer().writeToString(document);
                        document.normalize();
                    }
                    catch (ParserConfigurationException e) {
                        log.error((Object)sm.getString("jreLeakListener.xmlParseFail"), (Throwable)e);
                    }
                }
                if (this.ldapPoolProtection) {
                    try {
                        Class.forName("com.sun.jndi.ldap.LdapPoolManager");
                    }
                    catch (ClassNotFoundException e) {
                        if (JreVendor.IS_ORACLE_JVM) {
                            log.error((Object)sm.getString("jreLeakListener.ldapPoolManagerFail"), (Throwable)e);
                        }
                        log.debug((Object)sm.getString("jreLeakListener.ldapPoolManagerFail"), (Throwable)e);
                    }
                }
                if (this.classesToInitialize != null) {
                    StringTokenizer strTok = new StringTokenizer(this.classesToInitialize, ", \r\n\t");
                    while (strTok.hasMoreTokens()) {
                        String classNameToLoad = strTok.nextToken();
                        try {
                            Class.forName(classNameToLoad);
                        }
                        catch (ClassNotFoundException e) {
                            log.error((Object)sm.getString("jreLeakListener.classToInitializeFail", new Object[]{classNameToLoad}), (Throwable)e);
                        }
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(loader);
            }
        }
    }
}

