/*
作者: tdx_zy
说明: 依赖raphael.js自绘
用法: 必须注册才可用
*/
g_BlackClrL = ['#2d2d2d', '#232323', '#d5d5d5', '#ff3d01', '#07f407'];
g_WhiteClrL = ['#939fad', '#d3d9de', '#000000', '#ff3d01', '#07f407'];

var tdxPaperDraw={
//注册入ToRaphael中；画布对象可以直接调用
RegisterToRaphael : function (Paper){
	Paper.tdxReportBar=tdxPaperDraw.ReportBar;
},

/**/
ReportBar : function (LeftW,BottomH,sUint){
	if(this instanceof Raphael){
		tdxPaperDraw.ReportBar.Paper=this;
	}
	if(!(this instanceof tdxPaperDraw.ReportBar)){
		return new tdxPaperDraw.ReportBar(LeftW,BottomH,sUint);
	}
	if(tdxPaperDraw.ReportBar.Paper){
		this.Paper=tdxPaperDraw.ReportBar.Paper; //this.Paper是该画布
	}
	this.PathSet=this.Paper.set();
	if(arguments.length<3){
		this.LeftW=30;
		this.BottomH=20;
		this.x=0;
		this.y=10;
		this.sUint='';
	}
	else{
		this.LeftW=LeftW;
		this.BottomH=BottomH;
		this.x=LeftW;
		this.y=10;
		this.sUint=sUint;
	}
	this.Tooltip;
	this.w = 160;
	this.h = 95;
	this.BottomPointX=[this.x+this.w/3-this.w/6, this.x+this.w*2/3-this.w/6, this.x+this.w-this.w/6];
	this.BottomPointY=this.y+this.h;
	this.ClrList = g_BlackClrL;
	var body = document.getElementById("bodyid");
	if(body.currentStyle && ( (body.currentStyle['color'])=='#000' || (body.currentStyle['color'])=='#000000') ){
		this.ClrList = g_WhiteClrL;
	}
	//外框clr1 内线clr2 字clr3 bar clr4
	this.setBarAttr = function(){
		clr1 = this.ClrList[0];
		clr2 = this.ClrList[1];
		var strLine = 'M'+(this.x)+','+(this.y);
		strLine += ' L'+(this.x)+','+(this.y+this.h);
		strLine += ' L'+(this.x+this.w)+','+(this.y+this.h);
		this.Paper.path(strLine).attr({
			'stroke-width':1,
			'stroke':clr1
		});

		/*for(var i=1;i<4;i++){
			var strLine = 'M'+(this.x)+','+(this.y+i*this.h/4)+' L'+(this.x+this.w)+','+(this.y+i*this.h/4);
			this.Paper.path(strLine).attr({
				'stroke-width':1,
				'stroke':clr2
			});
			var strLine = 'M'+(this.BottomPointX[i-1])+','+(this.y)+' L'+(this.BottomPointX[i-1])+','+(this.y+this.h);
			this.Paper.path(strLine).attr({
				'stroke-width':1,
				'stroke':clr2
			});
		}*/
	}
	
	//data: [['2012',val1,],['2011',val1,val2..]] 大到小 barcnt:索引号;如果是99表示所有
	this.setDayReportBar=function(data,barcnt,des){
		var self = this;
		if(this.PathSet){this.PathSet.remove();}
		if(data && data.length>0){
			var LDate=[];
			var LVal=[];
			for(var i = 0;i<data.length&&i<3;i++){
				LDate.push(data[i][0]);
				if(barcnt === 99){
					for(var j=1;j<data[i].length;j++){
						if(!isNaN(parseFloat(data[i][j]))){
							LVal.push(Math.abs(parseFloat(data[i][j])));
						}
					}
				}
				else{
					if(!isNaN(parseFloat(data[i][barcnt])))
						LVal.push(Math.abs(parseFloat(data[i][barcnt])));
				}
			}
			var MAX = Math.max.apply(null,LVal);
			var MIN = Math.min.apply(null,LVal);

			var strLen = (Math.abs(parseInt(MAX)).toString()).length;
			var PerVal = (MAX - 0)/7;
			var PerValPX;
			var LLeft;
			if(MAX==0){
				LLeft = [0,1,2,3,4];
				PerValPX = this.h/(LLeft[4]-LLeft[0]);
			}
			else{
				PerValPX = this.h/(Math.abs(PerVal)*8);
				LLeft = [0,2*PerVal,4*PerVal,6*PerVal,8*PerVal];
			}
			switch(strLen){
				case 1:
					des = des +'('+'元'+')';break;
				case 2:
					des = des +'('+'10元'+')';break;
				case 3:
					des = des +'('+'100元'+')';break;
				case 4:
					des = des +'('+'1000元'+')';break;
				case 5:
					des = des +'('+'万'+')';break;
				case 6:
					des = des +'('+'10万'+')';break;
				case 7:
					des = des +'('+'100万'+')';break;
				case 8:
					des = des +'('+'1000万'+')';break;
				case 9:
					des = des +'('+'亿'+')';break;
				case 10:
					des = des +'('+'10亿'+')';break;
				case 11:
					des = des +'('+'100亿'+')';break;
				case 12:
					des = des +'('+'1000亿'+')';break;
				case 13:
					des = des +'('+'万亿'+')';break;
				default:
					des = des +'('+'元'+')';
			}
			//画左边
			for(var i = LLeft.length-1; i>=0; --i){
				var sText;
				if(strLen<=1)
					sText = (LLeft[i]).toFixed(2);
				else
					sText = (LLeft[i]/(Math.pow(10,strLen-1))).toFixed(2);
				sText = sText.toString();
				this.PathSet.push(this.Paper.text(this.x-2, this.y+(LLeft.length-i-1)*this.h/4, sText).attr({
					'fill':this.ClrList[2],
					'font-family': 'arial',
					'font-size':'11px',
					'font-weight': 'normal',
					'text-anchor': 'end'
				}));
			}
			//画日期
			for(var i = 0;i<data.length&&i<3;i++){
				this.PathSet.push(this.Paper.text(this.BottomPointX[i], this.BottomPointY+10, LDate[i]).attr({
					'fill':this.ClrList[2],
					'font-family': 'arial',
					'font-size':'11px',
					'font-weight': 'normal'
				}));
			}
			//画bar
			if(barcnt === 99){
				for(var i = 0;i<data.length&&i<3;i++){
					var BarW = 6;
					var DiffW = 2;
					var sPx = this.BottomPointX[i]-BarW*2-DiffW/2*3;
					for(var j=0; j<barcnt; j++){
						var Barval = parseFloat(data[i][j+1]);
						if(!isNaN(Barval)){
							var clr = this.ClrList[3];
							if(Barval<0) clr = this.ClrList[4];
							var BarH = Math.abs(Barval) * PerValPX;
							var BarElm = this.Paper.rect(sPx+j*(BarW+DiffW), this.BottomPointY-BarH-1, BarW, BarH).attr({
								'fill':clr,
								'stroke-width':0
							})
							this.PathSet.push( BarElm );
							BarElm.tooltipval = this.Format(Barval);
							BarElm.cX = this.x+30;
							BarElm.cY = this.y+1;
							BarElm.clr = clr;
							BarElm.mouseover(function(){
								if(self.Tooltip){
									self.Tooltip.remove();
								}
								self.Tooltip = self.Paper.text(this.cX, this.cY, this.tooltipval).attr({
									'fill':this.clr,
									'font-family': 'arial',
									'font-size':'11px',
									'font-weight': 'normal',
									'text-anchor': 'middle'
								});
								
							});
							BarElm.mouseout(function(){
								if(self.Tooltip){
									self.Tooltip.remove();
								}
							});
						}
					}
				}
			}
			else{
				for(var i = 0;i<data.length&&i<3;i++){
					var BarW = 14;
					var Barval = parseFloat(data[i][barcnt]);
					if(!isNaN(Barval)){
						var clr = this.ClrList[3];
						if(Barval<0) clr = this.ClrList[4];
						var BarH = Math.abs(Barval) * PerValPX;
						var BarElm = this.Paper.rect(this.BottomPointX[i]-BarW/2, this.BottomPointY-BarH-1, BarW, BarH).attr({
							'fill':clr,
							'stroke-width':0
						})
						this.PathSet.push( BarElm );
						BarElm.tooltipval = this.Format(Barval);
						BarElm.cX = this.x+30;
						BarElm.cY = this.y+1;
						BarElm.clr = clr;
						BarElm.mouseover(function(){
							if(self.Tooltip){
								self.Tooltip.remove();
							}
							self.Tooltip = self.Paper.text(this.cX, this.cY, this.tooltipval).attr({
								'fill':this.clr,
								'font-family': 'arial',
								'font-size':'11px',
								'font-weight': 'normal',
								'text-anchor': 'middle'
							});
							
						});
						BarElm.mouseout(function(){
							if(self.Tooltip){
								self.Tooltip.remove();
							}
						});
					}
				}
			}
			this.PathSet.push(this.Paper.text(this.x+this.w, this.y, des).attr({
				'fill':this.ClrList[2],
				'font-family': 'arial',
				'font-size':'11px',
				'font-weight': 'normal',
				'text-anchor': 'end'
			}));
		}
	}

	this.Format = function(val){
		try{
			var v = parseFloat(val);
			if (v>=10000000000 || v<=-10000000000){
				v = v/100000000;
				return v.toFixed(0)+'亿';
			}
			else if(v>=100000000 || v<=-100000000){
				v = v/100000000;
				return v.toFixed(2)+'亿';
			}
			else if(v>=1000000 || v<=-1000000){
				v = v/10000;
				return v.toFixed(0)+'万';
			}
			else if(v>=10000 || v<=-10000){
				v = v/10000;
				return v.toFixed(2)+'万';
			}
			else{
				return v.toFixed(2)+'元';
			}
		}
		catch(e){
			return '--'
		}
	}
}

}; //tdxPaperDraw

//Cookie
function SetCookie(name,value,extimes){
	extimes = extimes*1000; //秒
	var extime = new Date();
	extime.setTime(extime.getTime() + extimes); 
	document.cookie = name + "=" + escape(value) + ((extimes==null) ? "" : ";expires=" + extime.toGMTString());
}
function GetCookie(name){
	var arr,reg=new RegExp("(^| )"+name+"=([^;]*)(;|$)");
    if(arr = document.cookie.match(reg)){
        return unescape(arr[2]); 
    }
    else 
        return "";
}
function DelCookie(name){
	var value = TdxUtils.GetCookie(name); 
	if(value.length>0){
		TdxUtils.SetCookie(name,value,-1);
	}
}