/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Invokers;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyType;

class InvokeGeneric {
    private final MethodType erasedCallerType;
    private final MethodHandle initialInvoker;
    private static final Class<?>[] EXTRA_ARGS = new Class[]{MethodType.class, MethodHandle.class};
    static final boolean USE_AS_TYPE_PATH = true;

    InvokeGeneric(MethodType methodType) throws ReflectiveOperationException {
        assert (methodType.equals((Object)methodType.erase()));
        this.erasedCallerType = methodType;
        this.initialInvoker = this.makeInitialInvoker();
        assert (this.initialInvoker.type().equals((Object)methodType.insertParameterTypes(0, MethodType.class, MethodHandle.class))) : this.initialInvoker.type();
    }

    private static MethodHandles.Lookup lookup() {
        return MethodHandles.Lookup.IMPL_LOOKUP;
    }

    static MethodHandle generalInvokerOf(MethodType methodType) throws ReflectiveOperationException {
        InvokeGeneric invokeGeneric = new InvokeGeneric(methodType);
        return invokeGeneric.initialInvoker;
    }

    private MethodHandle makeInitialInvoker() throws ReflectiveOperationException {
        MethodHandle methodHandle = this.makePostDispatchInvoker();
        MethodHandle methodHandle2 = this.returnConversionPossible() ? MethodHandles.foldArguments(methodHandle, this.dispatcher("dispatchWithConversion")) : MethodHandles.foldArguments(methodHandle, this.dispatcher("dispatch"));
        return methodHandle2;
    }

    private MethodHandle makePostDispatchInvoker() {
        MethodType methodType = this.erasedCallerType.insertParameterTypes(0, EXTRA_ARGS);
        return methodType.invokers().exactInvoker();
    }

    private MethodHandle dropDispatchArguments(MethodHandle methodHandle) {
        assert (methodHandle.type().parameterType(0) == MethodHandle.class);
        return MethodHandles.dropArguments(methodHandle, 1, EXTRA_ARGS);
    }

    private MethodHandle dispatcher(String string) throws ReflectiveOperationException {
        return InvokeGeneric.lookup().bind(this, string, MethodType.methodType(MethodHandle.class, MethodType.class, MethodHandle.class));
    }

    private MethodHandle dispatch(MethodType methodType, MethodHandle methodHandle) {
        MethodType methodType2 = methodHandle.type();
        MethodHandle methodHandle2 = methodHandle.asType(methodType);
        methodType2 = methodType;
        Invokers invokers = methodType2.invokers();
        MethodHandle methodHandle3 = invokers.erasedInvokerWithDrops;
        if (methodHandle3 == null) {
            invokers.erasedInvokerWithDrops = methodHandle3 = this.dropDispatchArguments(invokers.erasedInvoker());
        }
        return methodHandle3.bindTo(methodHandle2);
    }

    private MethodHandle dispatchWithConversion(MethodType methodType, MethodHandle methodHandle) {
        MethodHandle methodHandle2 = this.dispatch(methodType, methodHandle);
        if (this.returnConversionNeeded(methodType, methodHandle)) {
            methodHandle2 = this.addReturnConversion(methodHandle2, methodType.returnType());
        }
        return methodHandle2;
    }

    private boolean returnConversionPossible() {
        Class<?> clazz = this.erasedCallerType.returnType();
        return !clazz.isPrimitive();
    }

    private boolean returnConversionNeeded(MethodType methodType, MethodHandle methodHandle) {
        Class<?> clazz = methodType.returnType();
        if (clazz == this.erasedCallerType.returnType()) {
            return false;
        }
        Class<?> clazz2 = methodHandle.type().returnType();
        return !VerifyType.isNullConversion(clazz2, clazz) || clazz.isInterface();
    }

    private MethodHandle addReturnConversion(MethodHandle methodHandle, Class<?> clazz) {
        MethodType methodType = methodHandle.type();
        MethodHandle methodHandle2 = ValueConversions.identity(clazz);
        methodHandle2 = methodHandle2.asType(methodHandle2.type().changeParameterType(0, methodType.returnType()));
        methodHandle = MethodHandles.filterReturnValue(methodHandle, methodHandle2);
        return methodHandle.asType(methodType);
    }

    public String toString() {
        return "InvokeGeneric" + this.erasedCallerType;
    }
}

