/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import controlP5.Label;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ControlP5.Layout
public class Bang
extends Controller<Bang> {
    protected int cnt;
    protected int triggerId = 2;

    public Bang(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0.0f, 0.0f, 20, 20);
        controlP5.register(controlP5.papplet, string, this);
    }

    protected Bang(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, float f, float f2, int n, int n2) {
        super(controlP5, controllerGroup, string, f, f2, n, n2);
        this._myCaptionLabel.setPadding(0, Label.paddingY).align(37, 13);
        this._myValue = 1.0f;
    }

    @Override
    protected void onEnter() {
        this.cnt = 0;
        this.isActive = true;
    }

    @Override
    protected void onLeave() {
        this.isActive = false;
    }

    @Override
    protected void mousePressed() {
        if (this.triggerId == 2) {
            this.cnt = -3;
            this.isActive = true;
            this.update();
        }
    }

    @Override
    protected void mouseReleased() {
        if (this.triggerId == 1) {
            this.cnt = -3;
            this.isActive = true;
            this.update();
        }
    }

    @Override
    protected void mouseReleasedOutside() {
        this.onLeave();
    }

    @ControlP5.Layout
    public Bang setTriggerEvent(int n) {
        this.triggerId = n;
        return this;
    }

    @ControlP5.Layout
    public int getTriggerEvent() {
        return this.triggerId;
    }

    @Override
    public Bang setValue(float f) {
        this._myValue = f;
        this.broadcast(2);
        return this;
    }

    @Override
    public Bang update() {
        return this.setValue(this._myValue);
    }

    @Override
    @ControlP5.Invisible
    public Bang updateDisplayMode(int n) {
        this.updateViewMode(n);
        return this;
    }

    @ControlP5.Invisible
    public Bang updateViewMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = new BangView();
                break;
            }
            case 1: {
                this._myControllerView = new BangImageView();
                break;
            }
        }
        return this;
    }

    @Override
    public String getInfo() {
        return "type:\tBang\n" + super.getInfo();
    }

    @Override
    public String toString() {
        return super.toString() + " [ " + this.getValue() + " ] " + "Bang" + " (" + this.getClass().getSuperclass() + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BangImageView
    implements ControllerView<Bang> {
        private BangImageView() {
        }

        @Override
        public void display(PApplet pApplet, Bang bang) {
            if (Bang.this.isActive) {
                pApplet.image(Bang.this.availableImages[2] ? Bang.this.images[2] : Bang.this.images[0], 0.0f, 0.0f);
            } else {
                pApplet.image(Bang.this.availableImages[1] ? Bang.this.images[1] : Bang.this.images[0], 0.0f, 0.0f);
            }
            if (Bang.this.cnt < 0) {
                pApplet.image(Bang.this.availableImages[1] ? Bang.this.images[1] : Bang.this.images[0], 0.0f, 0.0f);
                ++Bang.this.cnt;
            }
            if (!Bang.this.isActive && Bang.this.cnt >= 0) {
                pApplet.image(Bang.this.images[0], 0.0f, 0.0f);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BangView
    implements ControllerView<Bang> {
        private BangView() {
        }

        @Override
        public void display(PApplet pApplet, Bang bang) {
            if (Bang.this.isActive) {
                pApplet.fill(Bang.this.color.getActive());
            } else {
                pApplet.fill(Bang.this.color.getForeground());
            }
            if (Bang.this.cnt < 0) {
                pApplet.fill(Bang.this.color.getForeground());
                ++Bang.this.cnt;
            }
            pApplet.rect(0.0f, 0.0f, (float)Bang.this.width, (float)Bang.this.height);
            if (Bang.this.isLabelVisible) {
                Bang.this._myCaptionLabel.draw(pApplet, 0, 0, bang);
            }
        }
    }
}

