use File::Find;
use File::Basename;

@fileList;
$toolPath = "..\\..\\tools\\bin";
main();

sub main
{
	$srcPath = $ARGV[0];
	$destPath = $ARGV[1];
	
	finddepth (\&convert, $srcPath);
	
	foreach $entry (@fileList)
	{
		if ( $entry =~ /$srcPath(.*)/ )
		{
			$fileBase = $1;
			$srcFile = $srcPath . $fileBase . ".wav";
			$destFile = $destPath . $fileBase . ".ogg";
			$cmd = "\"$toolPath\\oggEnc\" -b 32 $srcFile -o $destFile";
	
			if (-e $destFile)
			{
				$srcWriteTime = (stat($srcFile))[9];
				$destWriteTime = (stat($destFile))[9];
				if ( $srcWriteTime > $destWriteTime )
				{
					if ( !(-w $destFile) )
					{
						print "p4 edit $destFile\n";
						`p4 edit $destFile`;					
					}
					`mkdir $destPath`;
					`$cmd`;
					print "\n\n";				
				}
				else
				{
					print "skipping $srcFile \n\n";
				}
			}
			else
			{			
				`mkdir $destPath`;
				`$cmd`;
				print "\n\n";
			}
		}
	}
	
	
}

sub convert
{
	$file = $_;
	
	if ( $file =~ /(.*).wav/ )
	{
		$fname = $1;
		$dir = $File::Find::dir;
		
		$fullName = $dir . "/$fname";
		@fileList = (@fileList , $fullName );
 	}
}