#pragma once

#include "stdafx.h"

#define UBERFUNCTION CALLBACK

struct UBER_ICON
{
	HWND hWnd;
	int IconIndex;
	int Reserved;	//Reserved for possible use in the future...
	RECT rect;
	wchar_t label[MAX_PATH];
	Gdiplus::Bitmap* bitmap;
};

enum UBER_OPTIONGROUPMODE
{
	UBER_GROUPMODE_NORMAL,
	UBER_GROUPMODE_HIDDEN,//Invisible setting: Usefull for easily storing data that UberIcon will remember
	UBER_GROUPMODE_CHECKBOX,
	UBER_GROUPMODE_RADIO
};

//InOut should be MAX_PATH characters long...
typedef void (UBERFUNCTION *UberAPI_Translate)(wchar_t* InOut);
#define Uber_Translate ((UberAPI_Translate)::GetProcAddress(GetModuleHandle(NULL), "Translate"))

typedef void (UBERFUNCTION *UberAPI_AddOption)(wchar_t* Group, wchar_t* Name, UINT Value, wchar_t* sValue);
#define Uber_AddOption ((UberAPI_AddOption)::GetProcAddress(GetModuleHandle(NULL), "AddOption"))

typedef void (UBERFUNCTION *UberAPI_SetOptionGroupMode)(wchar_t* Group, UBER_OPTIONGROUPMODE Mode);
#define Uber_SetOptionGroupMode ((UberAPI_SetOptionGroupMode)::GetProcAddress(GetModuleHandle(NULL), "SetOptionGroupMode"))

typedef void (UBERFUNCTION *UberAPI_SetOption)(wchar_t* Group, wchar_t* Name, UINT Value);
#define Uber_SetOption ((UberAPI_SetOption)::GetProcAddress(GetModuleHandle(NULL), "SetOption"))

typedef void (UBERFUNCTION *UberAPI_SetOptionString)(wchar_t* Group, wchar_t* Name, wchar_t* sValue);
#define Uber_SetOptionString ((UberAPI_SetOptionString)::GetProcAddress(GetModuleHandle(NULL), "SetOptionString"))

typedef UINT (UBERFUNCTION *UberAPI_GetOption)(wchar_t* Group, wchar_t* Name);
#define Uber_GetOption ((UberAPI_GetOption)::GetProcAddress(GetModuleHandle(NULL), "GetOption"))

typedef bool (UBERFUNCTION *UberAPI_GetOptionString)(wchar_t* Group, wchar_t* Name, wchar_t* sValueOut);
#define Uber_GetOptionString ((UberAPI_GetOptionString)::GetProcAddress(GetModuleHandle(NULL), "GetOptionString"))

typedef const wchar_t*(UBERFUNCTION *UberAPI_GetOptionFromGroup)(wchar_t* Group);
#define Uber_GetOptionFromGroup ((UberAPI_GetOptionFromGroup)::GetProcAddress(GetModuleHandle(NULL), "GetOptionFromGroup"))