#pragma once
#include <sstream>
#include <vector>
#include <algorithm>
#include <iomanip>
#include <fstream>
#include <map>
#include <utility>

namespace UTAU{

	///////////////////////////////////////////////////////////////////////////
	// 萔
	///////////////////////////////////////////////////////////////////////////
	/// p[Xۂ̍s̎ނ\񋓌^
	enum LineType{
		ParameterLine	= 0x0100,	///< ZNVł͂Ȃp[^\sirbgZq&Ŏgpj
		UnknownLine,				///< m̃p[^
		LengthLine,					///< Length=
		LyricLine,					///< Lyric=
		NoteNumLine,				///< NoteNum=
		TempoLine,					///< Tempo=
		CacheLine,					///< CacheDir=
		SectionLine		= 0x1000,	///< ZNVJns\irbgZq&Ŏgpj
		UnknownSection,				///< mZNV
		NormalSection,				///< [#0000] ʏ̃ZNV
		PrevSection,				///< [#PREV]
		NextSection,				///< [#NEXT]
		SettingSection,				///< [#SETTING]
		TrackEndSection,			///< [#TRACKEND]
	};

	/// UTAU::Section.number ŁAlgpȂꍇɎg萔
	const int NoNumber = 10000;

	/*************************************************************************/
	/// UTAU֘At@C̃ZNV\NX.
	/// UTAU::SectionVector ͂̃NX̔z
	/// @author	
	/// @date	2012/01/20
	/// @sa		UTAU::SectionVector
	/*************************************************************************/
	class Section{
	public:
		
		///////////////////////////////////////////////////////////////////////////
		// 萔
		///////////////////////////////////////////////////////////////////////////
		
		/// ZNV̎ނ\񋓌^
		enum SectionType{
			SectionUnknown,		///< ʕs
			SectionNormal,		///< [#0000] ʏ̔ԍtZNV
			SectionSetting,		///< [#SETTING]
			SectionPrev,		///< [#PREV]
			SectionNext,		///< [#NEXT]
			SectionDelete,		///< [#DELETE]
			SectionInsert,		///< [#INSERT]
			SectionTrackEnd		///< [#TRACKEND]
		};

		///////////////////////////////////////////////////////////////////////////
		// public ϐ
		///////////////////////////////////////////////////////////////////////////
		
		SectionType	type;		///< ZNV̎ SectionUnknown ̂Ƃɂ name gp
		int			number;		///< ZNVԍ KvȂ^Cv̎ UTAU::NoNumber
		std::string	name;		///< ZNV ZNV̎ނsȎɂ̂ݎgp
		std::string lyric;		///< ̎
		int			note;		///< m[gio[
		int			length;		///< m[g̒
		float		tempo;		///< e|
		std::map<std::string, std::string>
					unknownParameters;	///< m̃p[^̂߂ std::map
		

		///////////////////////////////////////////////////////////////////////////
		/// RXgN^.
		/// @param type		ZNV̎ UTAU::Section::SectionType
		/// @param lyric	̎
		/// @param note		m[gio[
		/// @param length	̒
		/// @param number	ZNVԍ
		///////////////////////////////////////////////////////////////////////////
		Section(
			const SectionType type=SectionNormal,
			const std::string lyric="",
			const int note=0,
			const int length=0,
			const int number=NoNumber
		)
			:	type(type), number(number), name(""), lyric(lyric),
				note(note), length(length), tempo(0.0)
		{

		}


		///////////////////////////////////////////////////////////////////////////
		/// rZq == ̃I[o[[h.
		/// <algorithm>  std::search() ɑΉ邽߂̕
		/// ̎Ɖ̒ƃe|݂̂r悤ɂȂĂ
		///////////////////////////////////////////////////////////////////////////
		bool operator==(const Section& section) const{
			if(lyric == section.lyric && note == section.note &&
				length == section.length && tempo == section.tempo){
					return true;
			}
			return false;
		}
	};

	/*************************************************************************/
	/// UTAU::Section ̔z.
	/// std::vector<UTAU::Section> p̂ŁAXg[ւ̏oA
	/// <algorithm>  search() gpAm[g find() ȂǂB
	/// ܂Ae|LbVpXȂǁA[#SETTING]̓eێB
	/// @author	
	/// @date	2012/01/20
	/// @sa		UTAU::Section
	/*************************************************************************/
	class SectionVector: public std::vector<Section>{
	public:
		
		///////////////////////////////////////////////////////////////////////////
		// public ϐ
		///////////////////////////////////////////////////////////////////////////
		float		tempo;		///< vWFNgŜ̃e|
		std::string cachePath;	///< LbVpX
		std::string ustPath;	///< ustt@C̃pX
		std::map<std::string, std::string>
			unknownParameters;	///< m̃p[^̂߂ std::map
		
		///////////////////////////////////////////////////////////////////////////
		/// <algorithm> std::search() gpvfT.
		/// @param	pattern	T UTAU::SectionVector
		/// @bug	̃\bh݂͌̎ł #PREV ւ̑ΉĂȂߐ퓮삵Ȃ
		/// @sa		UTAU::Section::operator==()
		///////////////////////////////////////////////////////////////////////////
		std::vector<Section>::const_iterator find(const SectionVector& pattern) const{
			return std::search(begin(), end(), pattern.begin(), pattern.end());
		}

		///////////////////////////////////////////////////////////////////////////
		/// w肳ꂽZNVԍm[gւ̃Ce[^Ԃ.
		/// @param	sectionNumber	TZNVԍ
		/// @return	w肳ꂽԍ̃m[g std::vector<UTAU::Section>::const_iterator
		///////////////////////////////////////////////////////////////////////////
		std::vector<Section>::const_iterator getNote(int sectionNumber) const{
			for(std::vector<Section>::const_iterator i = this->begin(); i!=this->end(); ++i){
				if(i->number == sectionNumber) return i;
			}
			return this->end();
		}
	};

	///////////////////////////////////////////////////////////////////////////
	/// Xg[Zq << gpo.
	/// _ł͊SȑΉƂȂĂȂ߁Â܂܏oĂA
	/// ꎞt@Custt@CƂĂ̎gp͏oȂB
	/// @todo	ꎞt@Cւ̊SΉ
	/// @memo	ustt@Cւ̑Ή͕ʂ̌^ւ̃LXgȂǂgׂEEE
	///////////////////////////////////////////////////////////////////////////
	std::ostream& operator <<(std::ostream& stream, const SectionVector& section){
		// SETTING o
		stream << "[#SETTING]"			<< std::endl;
		stream << section.cachePath		<< std::endl;
		stream << section.ustPath		<< std::endl;
		stream << section.tempo			<< std::endl;

		// goiKj
		for(std::vector<Section>::const_iterator i=section.begin(); i<section.end(); ++i){
			
			switch(i->type){
				case Section::SectionPrev:
					stream << "[#PREV]"<< std::endl;
					break;
				case Section::SectionNext:
					stream << "[#NEXT]"<< std::endl;
					break;
				case Section::SectionDelete:
					stream << "[#DELETE]"<< std::endl;
					break;
				case Section::SectionNormal:
					stream << "[#" << std::setw(4) << std::setfill('0') << i->number << "]"<< std::endl;
					stream << "Length="		<< i->length	<< std::endl;
					stream << "NoteNum="	<< i->note		<< std::endl;
					stream << "Lyric="		<< i->lyric		<< std::endl;
					if(i->tempo > 0)
						stream << "Tempo=" << i->tempo		<< std::endl;
					// p:unknownParameters iterator i:section iterator
					for(auto p=i->unknownParameters.begin(); p!=i->unknownParameters.end(); ++p){
						stream << p->first << "=" << p->second << std::endl;
					}
					break;
				case Section::SectionInsert:
					stream << "[#INSERT]"<< std::endl;
					stream << "Length="		<< i->length	<< std::endl;
					stream << "NoteNum="	<< i->note		<< std::endl;
					stream << "Lyric="		<< i->lyric		<< std::endl;
					if(i->tempo > 0)
						stream << "Tempo=" << i->tempo		<< std::endl;
					// p:unknownParameters iterator i:section iterator
					for(auto p=i->unknownParameters.begin(); p!=i->unknownParameters.end(); ++p){
						stream << p->first << "=" << p->second << std::endl;
					}
					break;
			}
		}
		
		return stream;
	}


	/*************************************************************************/
	/// ustt@Cꎞt@C̓ǂݍ.
	/// static ȃ\bh̋lߍ킹Ȃ̂ŁA
	/// NX\bhƂČĂяoĎgpĂB
	/// @author	
	/// @date	2012/01/20
	/// @sa		UTAU::Section UTAU::SectionVector
	/*************************************************************************/
	class UstReader{

	private:
		///////////////////////////////////////////////////////////////////////////
		// private NXNX {͐؂蕪݈ˑ߂ǂ
		///////////////////////////////////////////////////////////////////////////
		
		/*************************************************************************/
		/// ZNṼp[T[̊NX.
		/// s̎ނԂ UTAU::UstReader::Parser::whatIsLine() ƁA
		/// p̂߂̏z֐ parse() B
		/// @author	
		/// @date	2012/01/20
		/// @sa		UTAU::UstReader
		/*************************************************************************/
		class Parser{
		public:
			///////////////////////////////////////////////////////////////////////////
			// public ϐ
			///////////////////////////////////////////////////////////////////////////
			
			///////////////////////////////////////////////////////////////////////////
			/// fXgN^.
			/// p邽ߔÔ virtual gp
			///////////////////////////////////////////////////////////////////////////
			virtual ~Parser(){};
			
			///////////////////////////////////////////////////////////////////////////
			/// p[Xsz֐.
			/// pɂꂼ̃p[T̃\bh̒g
			/// @param	buffer	t@C1s std::string
			/// @param	vector	ZNVۑ UTAU::SectionVector
			/// @param	file	ǂݍݒ̃t@C std::ifstream
			///////////////////////////////////////////////////////////////////////////
			virtual void parse(std::string& buffer, SectionVector& vector, std::ifstream& file) = 0;

			///////////////////////////////////////////////////////////////////////////
			/// ^ꂽustꎞt@CłȂ̍sȂ̂肷.
			/// @param	buffer	t@C1s std::string
			/// @return	s̎ނ UTAU::LineType ŕԂ
			///////////////////////////////////////////////////////////////////////////
			static LineType whatIsThisLine(const std::string& buffer){
				const std::string settingMarker	= "[#SETTING]";
				const std::string prevMarker		= "[#PREV]";
				const std::string nextMarker		= "[#NEXT]";
				const std::string trackEndMarker	= "[#TRACKEND]";
				const std::string sectionMarker	= "[#";
				const std::string lyricMarker		= "Lyric=";
				const std::string lengthMarker		= "Length=";
				const std::string noteNumMarker	= "NoteNum=";
				const std::string tempoMarker		= "Tempo=";
				const std::string cacheMarker		= "CacheDir=";

				// ZbeBO
				if(buffer.compare(0, settingMarker.length(), settingMarker) == 0)		return SettingSection;
				// I͈͂̑Õm[g
				else if(buffer.compare(0, prevMarker.length(), prevMarker) == 0)		return PrevSection;
				// I͈͂̎̃m[g
				else if(buffer.compare(0, nextMarker.length(), nextMarker) == 0)		return NextSection;
				// gbN̏I
				else if(buffer.compare(0, trackEndMarker.length(), trackEndMarker) == 0)return TrackEndSection;
				// ʏ̃ZNV
				else if(buffer.compare(0,sectionMarker.length(), sectionMarker) == 0 &&
					buffer[sectionMarker.length()] >= '0' && buffer[sectionMarker.length()] <= '9')	return NormalSection;
				// ̑̃ZNV
				else if(buffer.compare(0,sectionMarker.length(), sectionMarker) == 0)	return UnknownSection;
				// Length
				else if(buffer.compare(0,lengthMarker.length(), lengthMarker) == 0)		return LengthLine;
				// Lyric
				else if(buffer.compare(0,lyricMarker.length(), lyricMarker) == 0)		return LyricLine;
				// NoteNum
				else if(buffer.compare(0,noteNumMarker.length(), noteNumMarker) == 0)	return NoteNumLine;
				// Tempo
				else if(buffer.compare(0,tempoMarker.length(), tempoMarker) == 0)		return TempoLine;
				// CacheDir
				else if(buffer.compare(0,cacheMarker.length(), cacheMarker) == 0)		return CacheLine;
				// Other
				else return UnknownLine;
			}
		};

		/*************************************************************************/
		/// [#SETTING]ǂނ߂̃p[T.
		/// UTAU::UstReader::Parser p
		/// @author	
		/// @date	2012/01/20
		/// @sa		UTAU::UstReader::Parser
		/*************************************************************************/
		class SettingParser : public Parser {
		public:
			void parse(std::string& buffer, SectionVector& vector, std::ifstream& file){
				while(std::getline(file, buffer)){
					
					LineType type = whatIsThisLine(buffer);
					
					// ̃ZNV̓߂
					if(type & SectionLine) return;

					switch(type){
					case TempoLine:
						std::stringstream(buffer.substr(buffer.find("=")+1)) >> vector.tempo;
						break;
					case CacheLine:
						vector.cachePath	= buffer.substr(buffer.find("=")+1);
						vector.ustPath		= vector.cachePath.substr(0, vector.cachePath.rfind(".")) + ".ust";
						break;
					case UnknownLine:
						// = OƌɕĖm̃p[^Ƃĕۑ
						vector.unknownParameters.insert(
							std::pair<std::string,std::string>(
								buffer.substr(0, buffer.find("=")),
								buffer.substr(buffer.find("=")+1)
							)
						); break;
					}
				}
			}
		};

		/*************************************************************************/
		/// ǂݔ΂߂̃p[T.
		/// UTAU::UstReader::Parser pBARXgN^ŁA
		/// ̃ZNVǂݔ΂̂ UTAU::Section::SectionType Ŏw肷B
		/// @author	
		/// @date	2012/01/20
		/// @sa		UTAU::UstReader::Parser
		/*************************************************************************/
		class SkipParser : public Parser {
			Section::SectionType type;
		public:
			
			void parse(std::string& buffer, SectionVector& vector, std::ifstream& file){
				
				Section section;
				section.number = NoNumber;
				section.type = type;
				// mȂZNVZNVێ i݂͖m̃ZNVparse()ł͂Ăj
				if(section.type == Section::SectionUnknown){
					// # I܂ł𔲂oĖOɓ
					section.name = buffer.substr(buffer.find("#")+1, buffer.length()-1-buffer.find("#"));
				}

				vector.push_back(section);

				while(std::getline(file, buffer)){
					if(whatIsThisLine(buffer) & SectionLine) return;
				}

			}

			SkipParser(const Section::SectionType type)
				: type(type){
			}

		};

		/*************************************************************************/
		/// ʏ̃ZNVǂނ߂̃p[T.
		/// UTAU::UstReader::Parser pBʏ̃ZNV[#]ŕ\B
		/// @author	
		/// @date	2012/01/20
		/// @sa		UTAU::UstReader::Parser
		/*************************************************************************/
		class NormalParser : public Parser {
		public:
			void parse(std::string& buffer, SectionVector& vector, std::ifstream& file){
				
				Section section;

				// ZNVio[4Œ
				std::stringstream(buffer.substr(buffer.find("#")+1 , 4)) >> section.number;
				// ZNV^Cvݒ
				section.type	= Section::SectionNormal;

				while(std::getline(file, buffer)){

					LineType type = whatIsThisLine(buffer);
					if(type & SectionLine){
						vector.push_back(section);
						return;
					}
					switch(type){
					case LengthLine:
						std::stringstream(buffer.substr(buffer.find("=")+1)) >> section.length;
						break;
					case TempoLine:
						std::stringstream(buffer.substr(buffer.find("=")+1)) >> section.tempo;
						break;
					case NoteNumLine:
						std::stringstream(buffer.substr(buffer.find("=")+1)) >> section.note;
						break;
					case LyricLine:
						section.lyric = buffer.substr(buffer.find("=")+1);
						break;
					case UnknownLine:
						// = OƌɕĖm̃p[^Ƃĕۑ
						section.unknownParameters.insert(
							std::pair<std::string,std::string>(
							buffer.substr(0, buffer.find("=")),
							buffer.substr(buffer.find("=")+1)
							)
						); break;
					}
				}
				vector.push_back(section);
			}
		};
		///////////////////////////////////////////////////////////////////////////
		// NXNX܂
		///////////////////////////////////////////////////////////////////////////

		///////////////////////////////////////////////////////////////////////////
		/// ustt@Cꎞt@C1sǂݍ݃p[Xs.
		/// ۂ̃p[X UTAU::UstReader::Parser pAep[T[sB
		/// @param	vector	ZNVۑ UTAU::SectionVector
		/// @param	file	ǂݍݒ̃t@C std::ifstream
		/// @sa		UTAU::UstReader::Parser	
		///////////////////////////////////////////////////////////////////////////
		static void parse(std::ifstream& file, SectionVector& vector){

			// obt@
			std::string		buffer;

			// ܂1sǂݍ
			if(!std::getline(file, buffer)) return;

			// t@C̏I܂Ń[v
			while(file){

				// p[T[
				std::unique_ptr<Parser> parser;

				// ZNṼ^Cvɂď𕪂
				switch(Parser::whatIsThisLine(buffer)){
				case SettingSection:
					parser.reset(new SettingParser());break;
				case PrevSection:
					parser.reset(new SkipParser(Section::SectionPrev));break;
				case UnknownSection:
					//parser.reset(new SkipParser(Section::SectionUnknown));break;
					return; // m̃ZNV͈Ȃ
				case NormalSection:
					parser.reset(new NormalParser());break;
				case NextSection: return;
					parser.reset(new SkipParser(Section::SectionNext));break;
				case TrackEndSection: return;
				}

				// w肵p[T[Ńp[X
				parser->parse(buffer, vector, file);
			}
		}

	public:

		///////////////////////////////////////////////////////////////////////////
		/// w肳ꂽpXJăp[XĂяo.
		/// @param	path	t@CpX\ std::string(I[o[[h char* )
		/// @param	vector	ZNVۑ邽߂ UTAU::SectionVector
		/// @return	t@CJ true JȂ false
		/// @sa		UTAU::UstReader::parse()
		/// @note	̎ł̓p[XĂяoʒu\zďo@Ȃ
		///////////////////////////////////////////////////////////////////////////
		static bool open(const std::string& path, SectionVector& vector){
			std::ifstream	file(path);
			if(!file){
				return false;
			}
			else{
				parse(file, vector);
				return true;
			}
			
		}

		///////////////////////////////////////////////////////////////////////////
		/// w肳ꂽpXJăp[XĂяo.
		/// @param	path	t@CpX\ char* (I[o[[h std::string )
		/// @param	vector	ZNVۑ邽߂ UTAU::SectionVector
		/// @return	t@CJ true JȂ false
		/// @sa		UTAU::UstReader::parse()
		/// @note	̎ł̓p[XĂяoʒu\zďo@Ȃ
		///////////////////////////////////////////////////////////////////////////
		static bool open(const char* path, SectionVector& vector){
			return open(std::string(path), vector);
		}
	};
}