<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Component;

use Vvveb\System\Images as Images;

class Posts extends \Vvveb\System\Component {
	public static $designOnly = false;

	public static $defaultOptions = [
		'start'           => 0,
		'language_id'     => 1,
		'store_id'        => 0,
		'post_id'         => 'url',
		'rows'            => ['url', 4],
		'id_manufacturer' => NULL,
		'order'           => ['url', 'price asc'],
		'id_category'     => 'url',
		'id'              => NULL,
	];

	public $options = [];

	function results() {
		$posts = new \Vvveb\Sql\PostsSQL();

		$results = $posts->getPosts($this->options);

		foreach ($results['posts'] as $id => &$post) {
			if (isset($post['images'])) {
				$post['images'] = json_decode($post['images'], 1);

				foreach ($post['images'] as &$image) {
					$image = Images::image('post', $image);
				}
				//	var_dump($post['images']);
			}

			if (isset($post['image'])) {
				$post['images'][] = Images::image('post', $post['image']);
			}
		}

		return $results;
	}
}
