<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Controller\Content;

use Vvveb\Controller\Base as Base;
use Vvveb\Sql\PostsSQL as PostsSQL;
use Vvveb\System\Images as Images;
use Vvveb\System\Validator as Validator;
use Vvveb\System\View as View;

class Post extends Base {
	protected $type = 'post';

	function index() {
		$view = View :: getInstance();

		$view->languages = [
			['language_id' => 1,
				'name'        => 'english',
				'code'        => 'en', ],

			['language_id' => 2,
				'name'        => 'romanian',
				'code'        => 'ro', ],
		];

		if (isset($_GET['post_id'])) {
			$options = ['post_id' => (int)$_GET['post_id'], 'type' => $this->type];

			$posts = new PostsSQL();

			$view->post = $posts->getPost($options);

			//featured image
			if (isset($view->post['image'])) {
				$view->post['image_url'] = Images::image('post', $view->post['image']);
			}
			//$view->tags = $posts->postTags($options);
			//$view->categories = $posts->postCategories($options);
		} else {
			$view->post['image_url'] = Images::image('post');
		}

		$validator           = new Validator(['post']);
		$view->validatorJson = $validator->getJSON();
	}

	function save() {
		$validator = new Validator(['post']);
		$view      = view :: getInstance();

		if (($errors = $validator->validate($this->request->post)) === true) {
			$posts = new PostsSQL();

			//$post = ['post' => array('title' => $_POST['title'], 'content' =>  $_POST['content'])/*, 'id_post' => (int)$_GET['post_id']*/];
			$post = [];
			//$post = $this->request->post;

			if (isset($this->request->get['post_id'])) {
				$post['post_id'] = (int)$this->request->get['post_id'];
				//$post['type'] = $this->type;
				$post['post_array'] = $this->request->post;
				$result             = $posts->editPost($post);

				if ($result >= 0) {
					$this->view->success = ['Post saved'];
				} else {
					$this->view->validationErrors = [$posts->error];
				}
			} else {
				$return = $posts->addPost(['post' => $this->request->post]);
				$id     = $return['post'];

				if (! $id) {
					$view->validationErrors = [$posts->error];
				} else {
					$view->success = 'Post saved!';
					$this->redirect(['module'=>'content/post', 'post_id' => $id]);
				}
			}
		} else {
			$view->validationErrors = $errors;
		}

		$this->index();
	}

	function draft() {
	}

	function preview() {
	}
}
