<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Controller\Content;

use Vvveb\Controller\Base as Base;
use Vvveb\System\Images as Images;
use Vvveb\System\View as View;

class Posts extends Base {
	protected $type = 'post';

	function index() {
		$view  = View :: getInstance();
		$posts = new \Vvveb\Sql\postsSQL();

		$page    = $_GET['page'] ?? 1;
		$perpage = 10;

		$results = $posts->getPosts(
			[
				'start'       => ($page - 1) * $perpage,
				'rows'        => $perpage,
				'type'        => $this->type,
				'language_id' => 1,
				'store_id'    => 0,
			]
		);

		foreach ($results['posts'] as $id => &$post) {
			if (isset($post['image'])) {
				$post['image'] = Images::image('post', $post['image']);
			}
		}

		$view->posts = $results['posts'];
		$view->count = $results['count'];

		$view->fields = [
			'article' => ['type' => 'link', 'url'=> ''],
		];

		$view->perpage = $perpage;

		return null;
		//insert plugin html
		$view->psttt->insertHTML('public/admin/theme/default/content/posts.html', 'plugins/test/public/admin/content/posts.article.html', [
			//headcolumn
			[
				'insertSelector' => '[data-v-posts]table thead',
				'type'           => 'append',
				'selector'       => '[data-v-test-col]',
			],
			//row column
			[
				'insertSelector' => '[data-v-posts]table data-v-post .post',
				'type'           => 'after',
				'selector'       => '[data-v-test-row]',
			],
		]);
		$view->psttt->addTemplate('public/admin/theme/default/content/posts.pst', 'plugins/test/admin/content/posts.pst');
	}
}
