<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Controller\Editor;

use Vvveb\Controller\Base as Base;
use Vvveb\System\View as View;

class Autocomplete extends Base {
	private $themeConfig = [];

	function products() {
		$products = new \Vvveb\Sql\ProductsSQL();

		$results = $products->getProducts(
			['start'       => 0,
				'count'       => 10,
				'language_id' => 1,
				'store_id'    => 0,
				'search'      => '%' . $_GET['text'] . '%',
			]
		);

		foreach ($results['products'] as $product) {
			$search[$product['product_id']] = $product['name'];
		}

		$view         = View::getInstance();
		$view->noJson = true;

		echo json_encode($search);

		return false;
	}

	function categories() {
		$categories = new \Vvveb\Sql\CategoriesSQL();

		$results = $categories->getCategories(
			['start'       => 0,
				'count'       => 10,
				'language_id' => 1,
				'store_id'    => 0,
				'search'      => '%' . $_GET['text'] . '%',
			]
		);

		foreach ($results['categories'] as $category) {
			$search[$category['category_id']] = $category['name'];
		}

		$view         = View::getInstance();
		$view->noJson = true;

		echo json_encode($search);

		return false;
	}

	function manufacturers() {
		$manufacturers = new \Vvveb\Sql\ManufacturersSQL();

		$results = $manufacturers->getManufacturers(
			['start'       => 0,
				'count'       => 10,
				'language_id' => 1,
				'store_id'    => 0,
				'search'      => '%' . $_GET['text'] . '%',
			]
		);

		foreach ($results['manufacturers'] as $manufacturer) {
			$search[$manufacturer['manufacturer_id']] = $manufacturer['name'];
		}

		$view         = View::getInstance();
		$view->noJson = true;

		echo json_encode($search);

		return false;
	}

	function posts() {
		$posts = new \Vvveb\Sql\PostsSQL();

		$results = $posts->getPosts(
			['start'       => 0,
				'limit'       => 10,
				'language_id' => 1,
				'store_id'    => 0,
				'search'      => '%' . $_GET['text'] . '%',
			]
		);

		foreach ($results['posts'] as $post) {
			$search[$post['post_id']] = substr($post['name'],0, 50);
		}

		$view         = View::getInstance();
		$view->noJson = true;

		echo json_encode($search);

		return false;
	}
}
