<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Controller\Editor;

use Vvveb\Controller\Base as Base;
use Vvveb\System\Event as Event;
use Vvveb\System\Str as Str;
use Vvveb\System\View as View;

class Editor extends Base {
	private $themeConfig = [];

	function __construct() {
		//echo \Vvveb\url('product/product/index', ['product_id' => null]);
		//die();
		parent::__construct();
		$this->loadThemeConfig();
	}

	function getThemeFolder() {
		return DIR_THEMES . \Vvveb\config('app.theme', 'essence');
	}

	function loadThemeConfig() {
		$this->themeConfig = include $this->getThemeFolder() . '/theme.php';
	}

	function loadTemplateList() {
		$list = $this->themeConfig['pages'];

		$list = Event::trigger('editor', 'templateList', $list);

		return $list;
		$pages       = [];
		$themeFolder = $this->getThemeFolder();
		$files       = glob("$themeFolder{,**/}*.html", GLOB_BRACE);

		foreach ($files as $file) {
			$file     = preg_replace('@^.*/themes/\w+/@', '', $file);
			$filename = basename($file);
			$folder   = Str::match('@(\w+)/.*$@', $file);
			$name     = str_replace('.html', '', $filename);
			$pages[]  = ['name' => $name, 'filename' => $filename, 'file' => $file, 'url' => '//demo.givan.ro/public/themes/essence/' . $file, 'title' => ucfirst($name), 'folder' => $folder];
		}
	}

	function index() {
		$view               = View::getInstance();
		$view->pages        = $this->loadTemplateList();
		$view->themeBaseUrl = '/public/themes/' . \Vvveb\config('app.theme', 'essence');

		$themeFolder = $this->getThemeFolder();

		$files = glob("$themeFolder/editor/components/*.js", GLOB_BRACE);

		foreach ($files as &$file) {
			$file = str_replace($themeFolder, $view->themeBaseUrl, $file);
		}
		$view->themeComponents = $files;

		$files = glob("$themeFolder/editor/sections/*.js", GLOB_BRACE);

		foreach ($files as &$file) {
			$file = str_replace($themeFolder, $view->themeBaseUrl, $file);
		}
		$view->themeSections = $files;

		$files = glob("$themeFolder/editor/inputs/*.js", GLOB_BRACE);

		foreach ($files as &$file) {
			$file = str_replace($themeFolder, $view->themeBaseUrl, $file);
		}
		$view->themeInputs = $files;
	}

	function getComponent($html, $options) {
	}

	function backup($page) {
		$themeFolder  = $this->getThemeFolder();
		$backupFolder = $themeFolder . '/backup/';
		$page         = str_replace('.html', '', Str::sanitizeFilename($page));
		$backupName   =  $page . '|' . date('Y-m-d_H:i:s') . '.html';

		$content = file_get_contents($themeFolder . $page . '.html');

		return file_put_contents($backupFolder . $backupName, $content);
	}

	function save() {
		$page    = Str::sanitizeFilename($_POST['fileName']);
		$content = $_POST['html'];
		$message = ['success' => false, 'message' =>'Error saving file!'];

		if (! $this->backup($page)) {
			$message = ['success' => false, 'message' => 'Error saving backup!'];
		}

		$themeFolder = $this->getThemeFolder();

		if (file_put_contents($themeFolder . '/' . $page, $content)) {
			$message = ['success' => true, 'message' =>'File saved!'];
		}

		$view         = View::getInstance();
		$view->noJson = true;

		echo json_encode($message);

		return false;
	}
}
