<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Controller\Media;

use Vvveb\Controller\Base as Base;
use Vvveb\System\View as View;

class Media extends Base {
	function index() {
	}

	function scan($path = 'public') {
		switch ($path) {
			case 'public':
				$scandir = DIR_MEDIA;

			break;

			default:
				return false;
		}

		$scandir = DIR_MEDIA;
		//var_dump(DIR_MEDIA);
		// Run the recursive function

		// This function scans the files folder recursively, and builds a large array

		$scan = function ($dir) use ($scandir, &$scan) {
			$files = [];

			// Is there actually such a folder/file?

			if (file_exists($dir)) {
				foreach (scandir($dir) as $f) {
					if (! $f || $f[0] == '.') {
						continue; // Ignore hidden files
					}

					if (is_dir($dir . '/' . $f)) {
						// The path is a folder

						$files[] = [
							'name'  => $f,
							'type'  => 'folder',
							'path'  => str_replace($scandir, '', $dir) . '/' . $f,
							'items' => $scan($dir . '/' . $f), // Recursively get the contents of the folder
						];
					} else {
						// It is a file

						$files[] = [
							'name' => $f,
							'type' => 'file',
							'path' => str_replace($scandir, '', $dir) . '/' . $f,
							'size' => filesize($dir . '/' . $f), // Gets the size of this file
						];
					}
				}
			}

			return $files;
		};

		$response = $scan($scandir);

		// Output the directory listing as JSON
		$view         = View::getInstance();
		$view->noJson = true;

		header('Content-type: application/json');

		echo json_encode([
			'name'  => '',
			'type'  => 'folder',
			'path'  => '',
			'items' => $response,
		]);

		return false;
	}
}
