<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Controller\Order;

use Vvveb\Controller\Base as Base;
use Vvveb\Sql\OrdersSQL as OrdersSQL;
use Vvveb\System\View as View;

class Orders extends Base {
	function index() {
		$view     = View :: getInstance();
		$products = new OrdersSQL();

		$page    = $_GET['page'] ?? 1;
		$perpage = 10;

		$results = $products->getOrders(
			[
				'start'       => ($page - 1) * $perpage,
				'count'       => $perpage,
				'language_id' => 1,
				'store_id'    => 0,
			]
		);

		$view->orders = $results['orders'];
		$view->count  = $results['count'];
	}
}
