<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Controller\Product;

use Vvveb\Controller\Base as Base;
use Vvveb\Sql\ProductsSQL as ProductsSQL;
use Vvveb\System\Images as Images;
use Vvveb\System\Validator as Validator;
use Vvveb\System\View as View;

class Product extends Base {
	function categoriesAutocomplete() {
		$categories = new \Vvveb\Sql\CategoriesSQL();

		$results = $categories->getCategories(
			['start'       => 0,
				'count'       => 10,
				'language_id' => 1,
				'store_id'    => 0,
				'search'      => '%' . $_GET['text'] . '%',
			]
		);

		foreach ($results['categories'] as $category) {
			$search[$category['category_id']] = $category['name'];
		}

		$view         = View::getInstance();
		$view->noJson = true;

		echo json_encode($search);

		return false;
	}

	function productsAutocomplete() {
		$products = new \Vvveb\Sql\ProductsSQL();

		$results = $products->getProducts(
			['start'       => 0,
				'count'       => 10,
				'language_id' => 1,
				'store_id'    => 0,
				'search'      => '%' . $_GET['text'] . '%',
			]
		);

		foreach ($results['products'] as $product) {
			$search[$product['product_id']] = $product['name'];
		}

		echo json_encode($search);

		return false;
	}

	function index() {
		$view = View :: getInstance();

		$products   = new ProductsSQL();
		$view->data = $products->getProductData();

		if (isset($_GET['product_id'])) {
			$productOptions = ['product_id' => (int)$_GET['product_id']];

			$view->product = $products->getProduct($productOptions);

			//featured image
			if (isset($view->product['image'])) {
				$view->product['image_url'] = Images::image('product', $view->product['image']);
			}

			//gallery
			if (isset($view->product['images'])) {
				$view->product['images'] = Images::images('product', $view->product['images']);
			}

			//$view->productImages = $products->getProductImages($productOptions);
			$view->data['status'] = [0 => 'Disabled', 1 => 'Enabled'];
		} else {
			$view->product['image_url'] = Images::image('product');
		}

		$validator           = new Validator(['product']);
		$view->validatorJson = $validator->getJSON();
	}

	function save() {
		$validator = new Validator(['product']);
		//var_dump($_POST);

		$product = $this->request->post;
		//if (($this->view->validationErrors = $validator->validate($product)) === true)
		{
			$products = new ProductsSQL();

			if (isset($this->request->get['product_id'])) {
				$productId = (int)$this->request->get['product_id'];
				//var_dump($product['product_array']);
				$result = $products->editProduct(['product' => $product, 'product_id' => $productId]);

				if ($result >= 0) {
					$this->view->success = ['Product saved'];
				} else {
					$this->view->validationErrors = [$products->error];
				}
			} else {
				$result = $products->addProduct(['product' => $product, 'store_id' => 0]);

				if (! $result['product']) {
					$this->view->validationErrors = [$products->error];
				} else {
					$successMessage        = _('Product saved!');
					$this->view->success[] = $successMessage;
					$this->redirect(['module' => 'product/product', 'product_id' => $result['product'], 'success' => $successMessage]);
				}
			}
		}

		$this->index();
	}

	function draft() {
	}

	function preview() {
	}
}
