<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Controller\Settings;

use Vvveb\Controller\Base as Base;
use Vvveb\Sql\OptionsSQL as OptionsSQL;
use Vvveb\System\View as View;

class Settings extends Base {
	function index() {
		$options = new OptionsSQL();
		$results = $options->getOptions(['keys' => [], 'store_id' => 0]);
	}

	function save() {
		$validator = new Validator(['settings']);
		$view      = View :: getInstance();
		$settings  = $this->request->post;

		if (($errors = $validator->validate($settings)) === true) {
			$options              = new OptionsSQL();
			$settings             = $_POST;
			$settings['store_id'] = 0;

			$results = $options->setOptions($settings);
		}

		$this->index();
	}
}
