<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Sql;

class adminsSQL extends \Vvveb\System\Db\mysqli {
	public function __construct() {
		parent::__construct();
	}

	function get($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['user' => 's', 'email' => 's', 'admin_id' => 'i', 'status' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT * FROM admin AS _ WHERE 1';

		if (isset($params['user'])) {
			$sql .= ' AND _.user = :user ';
		}

		if (isset($params['email'])) {
			$sql .= ' AND _.email = :email ';
		}

		if (isset($params['admin_id'])) {
			$sql .= ' AND _.admin_id = :admin_id ';
		}

		if (isset($params['status'])) {
			$sql .= ' AND _.status = :status ';
		}

		$sql .= ' 
	LIMIT 1';

		if ($sql) {
			$stmt['_'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['_']) {
				if (method_exists($stmt['_'], 'get_result')) {
					$result = $stmt['_']->get_result();
				} else {
					$result = $this->get_result($stmt['_']);
				}
			}

			/*
			if ('_' == '_') {
				$value = $result->fetch_array(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('_' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['_'][$row['']] = $values;

							$results['_'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('_' == '_') {
					$value = $result->fetch_array(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['_'] = $result->fetch_array(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function add($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['admin' => 'a'];

		$prevSql = $sql ?? '';
		$sql     = '';

		$filterArray = [
			'admin_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'bigint',
				'e' => 'auto_increment',
			],
			'user' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'password' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'email' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'url' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'registered' => [
				'd' => '\'1000-01-01 00:00:00\'',
				'n' => false,
				't' => 'datetime',
			],
			'activation_key' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'status' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'display_name' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'role_id' => [
				'd' => 'NULL',
				'n' => true,
				't' => 'int',
			],
		];
		$params['admin']= $this->filter($params['admin'], $filterArray,false);

		$sql = 'INSERT INTO admin 
			
			(';
		$sql .= '`' . implode('`,`', array_keys($params['admin']));
		$sql .= '` )
			
	  	VALUES ( ';

		list($_sql, $_params) = $this->expandArray($params['admin'], 'admin');

		$sql .= $_sql;

		if (is_array($_params)) {
			$paramTypes = array_merge($paramTypes, $_params);
		}

		$sql .= ' )';

		if ($sql) {
			$stmt['admin'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['admin']) {
				if (method_exists($stmt['admin'], 'get_result')) {
					$result = $stmt['admin']->get_result();
				} else {
					$result = $this->get_result($stmt['admin']);
				}
			}

			/*
			if ('admin' == '_') {
				$value = $this->insert_id;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('admin' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['admin'][$row['']] = $values;

							$results['admin'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('admin' == '_') {
					$value = $this->insert_id;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['admin'] = $this->insert_id;
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function update($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['user' => 's', 'email' => 's', 'admin_id' => 'i', 'admin' => 'a'];

		$prevSql = $sql ?? '';
		$sql     = '';

		$filterArray = [
			'admin_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'bigint',
				'e' => 'auto_increment',
			],
			'user' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'password' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'email' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'url' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'registered' => [
				'd' => '\'1000-01-01 00:00:00\'',
				'n' => false,
				't' => 'datetime',
			],
			'activation_key' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'status' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'display_name' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'role_id' => [
				'd' => 'NULL',
				'n' => true,
				't' => 'int',
			],
		];
		$params['admin']= $this->filter($params['admin'], $filterArray,false);

		$sql = '';

		if ($sql) {
			$stmt[''] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['']) {
				if (method_exists($stmt[''], 'get_result')) {
					$result = $stmt['']->get_result();
				} else {
					$result = $this->get_result($stmt['']);
				}
			}

			/*
			if ('' == '_') {
				$value = $this->affected_rows;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results[''][$row['']] = $values;

							$results[''][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('' == '_') {
					$value = $this->affected_rows;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results[''] = $this->affected_rows;
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'UPDATE admin 
			
			SET';

		list($_sql, $_params) = $this->expandList($params['admin'], 'admin');

		$sql .= ' ' . $_sql;

		if (is_array($_params)) {
			$paramTypes = array_merge($paramTypes, $_params);
		}

		$sql .= ' ' . '
	WHERE';

		if (isset($params['user'])) {
			$sql .= ' user = :user ';
		}

		if (isset($params['email'])) {
			$sql .= ' email = :email ';
		}

		if (isset($params['admin_id'])) {
			$sql .= ' admin_id = :admin_id ';
		}

		if ($sql) {
			$stmt['admin'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['admin']) {
				if (method_exists($stmt['admin'], 'get_result')) {
					$result = $stmt['admin']->get_result();
				} else {
					$result = $this->get_result($stmt['admin']);
				}
			}

			/*
			if ('admin' == '_') {
				$value = $this->affected_rows;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('admin' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['admin'][$row['']] = $values;

							$results['admin'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('admin' == '_') {
					$value = $this->affected_rows;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['admin'] = $this->affected_rows;
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function setRole($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['admin_id' => 'i', 'role' => 's', 'role_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'UPDATE admin 
			
			SET';

		if (isset($params['role_id'])) {
			$sql .= ' role_id = :role_id ';
		}

		if (isset($params['role'])) {
			$sql .= ' role_id = (SELECT role_id FROM roles WHERE name = :role) ';
		}

		$sql .= ' 
	WHERE admin_id = :admin_id';

		if ($sql) {
			$stmt['roles'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['roles']) {
				if (method_exists($stmt['roles'], 'get_result')) {
					$result = $stmt['roles']->get_result();
				} else {
					$result = $this->get_result($stmt['roles']);
				}
			}

			/*
			if ('roles' == '_') {
				$value = $this->insert_id;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('roles' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['roles'][$row['']] = $values;

							$results['roles'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('roles' == '_') {
					$value = $this->insert_id;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['roles'] = $this->insert_id;
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}
}
