<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Sql;

class categoriesSQL extends \Vvveb\System\Db\mysqli {
	public function __construct() {
		parent::__construct();
	}

	function getCategory($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['category_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT *
			FROM category as _ WHERE category_id = :category_id LIMIT 1';

		if ($sql) {
			$stmt['_'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['_']) {
				if (method_exists($stmt['_'], 'get_result')) {
					$result = $stmt['_']->get_result();
				} else {
					$result = $this->get_result($stmt['_']);
				}
			}

			/*
			if ('_' == '_') {
				$value = $result->fetch_array(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('_' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['_'][$row['']] = $values;

							$results['_'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('_' == '_') {
					$value = $result->fetch_array(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['_'] = $result->fetch_array(MYSQLI_ASSOC);
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'SELECT *, language_id as _ FROM category_description 
		WHERE category_id = :category_id';

		if ($sql) {
			$stmt['category_description'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['category_description']) {
				if (method_exists($stmt['category_description'], 'get_result')) {
					$result = $stmt['category_description']->get_result();
				} else {
					$result = $this->get_result($stmt['category_description']);
				}
			}

			/*
			if ('category_description' == '_') {
				$value = $result->fetch_array(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('language_id')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('category_description' == '_') {
							//$results[$row['language_id']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['category_description'][$row['language_id']] = $values;

							$results['category_description'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('category_description' == '_') {
					$value = $result->fetch_array(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['category_description'] = $result->fetch_array(MYSQLI_ASSOC);
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'SELECT *, category_image_id  as _
			FROM category_image as images
		WHERE category_id = :category_id';

		if ($sql) {
			$stmt['images'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['images']) {
				if (method_exists($stmt['images'], 'get_result')) {
					$result = $stmt['images']->get_result();
				} else {
					$result = $this->get_result($stmt['images']);
				}
			}

			/*
			if ('images' == '_') {
				$value = $result->fetch_array(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('category_image_id')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('images' == '_') {
							//$results[$row['category_image_id']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['images'][$row['category_image_id']] = $values;

							$results['images'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('images' == '_') {
					$value = $result->fetch_array(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['images'] = $result->fetch_array(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function editCategory($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['category_array' => 'a', 'category_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'DELETE FROM category_description WHERE category_id = :category_id';

		if ($sql) {
			$stmt['category_description'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['category_description']) {
				if (method_exists($stmt['category_description'], 'get_result')) {
					$result = $stmt['category_description']->get_result();
				} else {
					$result = $this->get_result($stmt['category_description']);
				}
			}

			/*
			if ('category_description' == '_') {
				$value = $this->insertId;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('category_description' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['category_description'][$row['']] = $values;

							$results['category_description'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('category_description' == '_') {
					$value = $this->insertId;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['category_description'] = $this->insertId;
				}
			}
			//}
		}

		$prevSql = $sql ?? '';

		foreach ($params['category_array']['category_description'] as $key => $rowParent) {
			$params['each']     = $rowParent;
			$paramTypes['each'] = 'a';
			$sql                = 'INSERT INTO category_description 
		
				(';
			$sql .= '`' . implode('`,`', array_keys($params['each']));
			$sql .= '` , category_id, meta_title, meta_description, meta_keyword )
			
			VALUES ( :each, :category_id, \'\', \'\', \'\' )';

			if ($sql) {
				$stmt['category_description'] = $this->execute($sql, $params, $paramTypes);

				$result = false;

				if ($stmt['category_description']) {
					if (method_exists($stmt['category_description'], 'get_result')) {
						$result = $stmt['category_description']->get_result();
					} else {
						$result = $this->get_result($stmt['category_description']);
					}
				}

				/*
				if ('category_description' == '_') {
					$value = $this->insertId;
					if (is_array($value))
					{
						$results = $results + $value;
					} else
					{
						$results = $value;
					}
				} else { */
				if (! empty('')) {
					if ($result) {
						while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
							$values = $row;

							if (! empty('')) {
								//$values = $row[''];
								$values = $row['array_value'];
							}

							if ('category_description' == '_') {
								//$results[$row['']] = $values;
								$results[$row['array_key']] = $values;
							} else {
								//$results['category_description'][$row['']] = $values;

								$results['category_description'][$row['array_key']] = $values;
							}
						}
					}
				} else {
					if ('category_description' == '_') {
						$value = $this->insertId;

						if (is_array($value)) {
							$results = $results + $value;
						} else {
							$results = $value;
						}
					} else {
						$results['category_description'] = $this->insertId;
					}
				}
				//}
			}
		}
		unset($params['each'], $paramTypes['each']);

		$prevSql = $sql ?? '';
		$sql     = '';

		$filterArray = [
			'category_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
				'e' => 'auto_increment',
			],
			'image' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'parent_id' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'top' => [
				'd' => '0',
				'n' => false,
				't' => 'tinyint',
			],
			'column' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'sort_order' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'status' => [
				'd' => '0',
				'n' => false,
				't' => 'tinyint',
			],
			'date_added' => [
				'd' => 'current_timestamp()',
				'n' => false,
				't' => 'datetime',
			],
			'date_modified' => [
				'd' => 'current_timestamp()',
				'n' => false,
				't' => 'datetime',
			],
		];
		$params['category_array']= $this->filter($params['category_array'], $filterArray,false);

		$sql = '';

		if ($sql) {
			$stmt[''] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['']) {
				if (method_exists($stmt[''], 'get_result')) {
					$result = $stmt['']->get_result();
				} else {
					$result = $this->get_result($stmt['']);
				}
			}

			/*
			if ('' == '_') {
				$value = $this->insertId;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results[''][$row['']] = $values;

							$results[''][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('' == '_') {
					$value = $this->insertId;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results[''] = $this->insertId;
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'UPDATE category 
			
			SET';

		list($_sql, $_params) = $this->expandList($params['category_array'], 'category_array');

		$sql .= ' ' . $_sql;

		if (is_array($_params)) {
			$paramTypes = array_merge($paramTypes, $_params);
		}

		$sql .= ' ' . '
	WHERE category_id = :category_id';

		if ($sql) {
			$stmt['category'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['category']) {
				if (method_exists($stmt['category'], 'get_result')) {
					$result = $stmt['category']->get_result();
				} else {
					$result = $this->get_result($stmt['category']);
				}
			}

			/*
			if ('category' == '_') {
				$value = $this->insertId;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('category' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['category'][$row['']] = $values;

							$results['category'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('category' == '_') {
					$value = $this->insertId;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['category'] = $this->insertId;
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function addCategory($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['category_data' => 'a'];

		$prevSql = $sql ?? '';
		$sql     = '';

		$filterArray = [
			'category_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
				'e' => 'auto_increment',
			],
			'image' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'parent_id' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'top' => [
				'd' => '0',
				'n' => false,
				't' => 'tinyint',
			],
			'column' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'sort_order' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'status' => [
				'd' => '0',
				'n' => false,
				't' => 'tinyint',
			],
			'date_added' => [
				'd' => 'current_timestamp()',
				'n' => false,
				't' => 'datetime',
			],
			'date_modified' => [
				'd' => 'current_timestamp()',
				'n' => false,
				't' => 'datetime',
			],
		];
		$params['category']= $this->filter($params['category_data'], $filterArray,false);

		$sql = '';

		if ($sql) {
			$stmt[''] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['']) {
				if (method_exists($stmt[''], 'get_result')) {
					$result = $stmt['']->get_result();
				} else {
					$result = $this->get_result($stmt['']);
				}
			}

			/*
			if ('' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results[''][$row['']] = $values;

							$results[''][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results[''] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = '';

		$filterArray = [
			'category_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
			],
			'language_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
			],
			'name' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'slug' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'description' => [
				'd' => NULL,
				'n' => false,
				't' => 'text',
			],
			'meta_title' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'meta_description' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'meta_keyword' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
		];
		$params['category_description']= $this->filter($params['category_data'], $filterArray,false);

		$sql = '';

		if ($sql) {
			$stmt[''] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['']) {
				if (method_exists($stmt[''], 'get_result')) {
					$result = $stmt['']->get_result();
				} else {
					$result = $this->get_result($stmt['']);
				}
			}

			/*
			if ('' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results[''][$row['']] = $values;

							$results[''][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results[''] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'INSERT INTO category 
		
			(';
		$sql .= '`' . implode('`,`', array_keys($params['category']));
		$sql .= '` )
			
		VALUES ( :category )';

		if ($sql) {
			$stmt['category'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['category']) {
				if (method_exists($stmt['category'], 'get_result')) {
					$result = $stmt['category']->get_result();
				} else {
					$result = $this->get_result($stmt['category']);
				}
			}

			/*
			if ('category' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('category' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['category'][$row['']] = $values;

							$results['category'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('category' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['category'] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'SET @category_id = LAST_INSERT_ID()';

		if ($sql) {
			$stmt[''] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['']) {
				if (method_exists($stmt[''], 'get_result')) {
					$result = $stmt['']->get_result();
				} else {
					$result = $this->get_result($stmt['']);
				}
			}

			/*
			if ('' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results[''][$row['']] = $values;

							$results[''][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results[''] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'INSERT INTO category_description 
		
			( `category_id`,';
		$sql .= '`' . implode('`,`', array_keys($params['category_description']));
		$sql .= '` )
			
		VALUES ( @category_id,';

		list($_sql, $_params) = $this->expandList($params['category_description'], 'category_description');

		$sql .= ' ' . $_sql;

		if (is_array($_params)) {
			$paramTypes = array_merge($paramTypes, $_params);
		}

		$sql .= ' ' . '
	)';

		if ($sql) {
			$stmt['category_description'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['category_description']) {
				if (method_exists($stmt['category_description'], 'get_result')) {
					$result = $stmt['category_description']->get_result();
				} else {
					$result = $this->get_result($stmt['category_description']);
				}
			}

			/*
			if ('category_description' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('category_description' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['category_description'][$row['']] = $values;

							$results['category_description'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('category_description' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['category_description'] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'SELECT @category_id as category_id';

		if ($sql) {
			$stmt[''] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['']) {
				if (method_exists($stmt[''], 'get_result')) {
					$result = $stmt['']->get_result();
				} else {
					$result = $this->get_result($stmt['']);
				}
			}

			/*
			if ('' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results[''][$row['']] = $values;

							$results[''][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results[''] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function getCategories($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['language_id' => 'i', 'customer_group_id' => 'i', 'store_id' => 'i', 'search' => 's', 'start' => 'i', 'count' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT * FROM category AS categories
		
			LEFT JOIN category_to_store p2s ON (categories.category_id = p2s.category_id) 
			LEFT JOIN category_description pd ON (categories.category_id = pd.category_id)  

			WHERE 
			
			pd.language_id = :language_id AND p2s.store_id = :store_id';

		if (isset($params['search'])) {
			$sql .= ' AND pd.name LIKE :search ';
		}

		$sql .= ' 
	LIMIT :start, :count';

		if ($sql) {
			$stmt['categories'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['categories']) {
				if (method_exists($stmt['categories'], 'get_result')) {
					$result = $stmt['categories']->get_result();
				} else {
					$result = $this->get_result($stmt['categories']);
				}
			}

			/*
			if ('categories' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('categories' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['categories'][$row['']] = $values;

							$results['categories'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('categories' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['categories'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'SELECT count(*) FROM (';

		$sql .= $this->sqlCount($prevSql, 'categories.category_id', $this->prefix . 'category');
		$sql .= '
	
	) as count';

		if ($sql) {
			$stmt['count'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['count']) {
				if (method_exists($stmt['count'], 'get_result')) {
					$result = $stmt['count']->get_result();
				} else {
					$result = $this->get_result($stmt['count']);
				}
			}

			/*
			if ('count' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('count' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['count'][$row['']] = $values;

							$results['count'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('count' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['count'] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}
}
