<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Sql;

class customersSQL extends \Vvveb\System\Db\mysqli {
	public function __construct() {
		parent::__construct();
	}

	function getCustomers($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['language_id' => 'i', 'store_id' => 'i', 'customer_id' => 'i', 'start' => 'i', 'count' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT * FROM customer AS customers 
		
			
		WHERE 1';

		if (isset($params['customer_id'])) {
			$sql .= ' AND o.customer_id = :customer_id ';
		}

		if ($sql) {
			$stmt['customers'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['customers']) {
				if (method_exists($stmt['customers'], 'get_result')) {
					$result = $stmt['customers']->get_result();
				} else {
					$result = $this->get_result($stmt['customers']);
				}
			}

			/*
			if ('customers' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('customers' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['customers'][$row['']] = $values;

							$results['customers'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('customers' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['customers'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'SELECT count(*) FROM (';

		$sql .= $this->sqlCount($prevSql, 'customer_id', $this->prefix . 'customer');
		$sql .= '
	
	) as count';

		if ($sql) {
			$stmt['count'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['count']) {
				if (method_exists($stmt['count'], 'get_result')) {
					$result = $stmt['count']->get_result();
				} else {
					$result = $this->get_result($stmt['count']);
				}
			}

			/*
			if ('count' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('count' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['count'][$row['']] = $values;

							$results['count'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('count' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['count'] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function getCustomer($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['customer_id' => 'i', 'customer_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT * FROM customer AS `customer` WHERE o.customer_id = :customer_id AND o.customer_id = :customer_id';

		if ($sql) {
			$stmt['customer'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['customer']) {
				if (method_exists($stmt['customer'], 'get_result')) {
					$result = $stmt['customer']->get_result();
				} else {
					$result = $this->get_result($stmt['customer']);
				}
			}

			/*
			if ('customer' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('customer' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['customer'][$row['']] = $values;

							$results['customer'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('customer' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['customer'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'SELECT `key` as array_key,`value` as array_value FROM customer_meta as _
			WHERE _.customer_id = :customer_id
            
	
		SELECT `product_id` as array_key FROM customer_product as products
			WHERE products.customer_id = :customer_id';

		if ($sql) {
			$stmt['products'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['products']) {
				if (method_exists($stmt['products'], 'get_result')) {
					$result = $stmt['products']->get_result();
				} else {
					$result = $this->get_result($stmt['products']);
				}
			}

			/*
			if ('products' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('key')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('value')) {
							//$values = $row['value'];
							$values = $row['array_value'];
						}

						if ('products' == '_') {
							//$results[$row['key']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['products'][$row['key']] = $values;

							$results['products'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('products' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['products'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function placeCustomer($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['customer' => 'a'];

		$prevSql = $sql ?? '';
		$sql     = '';

		$filterArray = [
			'customer_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
				'e' => 'auto_increment',
			],
			'customer_group_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
			],
			'store_id' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'language_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
			],
			'first_name' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'last_name' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'email' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'phone_number' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'fax' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'password' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'salt' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'cart' => [
				'd' => NULL,
				'n' => false,
				't' => 'text',
			],
			'wishlist' => [
				'd' => NULL,
				'n' => false,
				't' => 'text',
			],
			'newsletter' => [
				'd' => '0',
				'n' => false,
				't' => 'tinyint',
			],
			'address_id' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'custom_field' => [
				'd' => NULL,
				'n' => false,
				't' => 'text',
			],
			'ip' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'status' => [
				'd' => NULL,
				'n' => false,
				't' => 'tinyint',
			],
			'safe' => [
				'd' => NULL,
				'n' => false,
				't' => 'tinyint',
			],
			'token' => [
				'd' => NULL,
				'n' => false,
				't' => 'text',
			],
			'code' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'date_added' => [
				'd' => NULL,
				'n' => false,
				't' => 'datetime',
			],
		];
		$params['customer']= $this->filter($params['customer'], $filterArray,false);

		$sql = 'INSERT INTO `customer` 
			
			(';
		$sql .= '`' . implode('`,`', array_keys($params['customer']));
		$sql .= '` )
			
	  	VALUES ( ';

		list($_sql, $_params) = $this->expandArray($params['customer'], 'customer');

		$sql .= $_sql;

		if (is_array($_params)) {
			$paramTypes = array_merge($paramTypes, $_params);
		}

		$sql .= ' )';

		if ($sql) {
			$stmt['customer'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['customer']) {
				if (method_exists($stmt['customer'], 'get_result')) {
					$result = $stmt['customer']->get_result();
				} else {
					$result = $this->get_result($stmt['customer']);
				}
			}

			/*
			if ('customer' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('customer' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['customer'][$row['']] = $values;

							$results['customer'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('customer' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['customer'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}
}
