<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Sql;

class manufacturersSQL extends \Vvveb\System\Db\mysqli {
	public function __construct() {
		parent::__construct();
	}

	function getManufacturer($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['manufacturer_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT *
			FROM manufacturer as _ WHERE manufacturer_id = :manufacturer_id LIMIT 1';

		if ($sql) {
			$stmt['_'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['_']) {
				if (method_exists($stmt['_'], 'get_result')) {
					$result = $stmt['_']->get_result();
				} else {
					$result = $this->get_result($stmt['_']);
				}
			}

			/*
			if ('_' == '_') {
				$value = $result->fetch_array(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('_' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['_'][$row['']] = $values;

							$results['_'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('_' == '_') {
					$value = $result->fetch_array(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['_'] = $result->fetch_array(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function editManufacturer($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['manufacturer_array' => 'a', 'manufacturer_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = '';

		$filterArray = [
			'manufacturer_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
				'e' => 'auto_increment',
			],
			'name' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'image' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'sort_order' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
			],
		];
		$params['manufacturer_array']= $this->filter($params['manufacturer_array'], $filterArray,false);

		$sql = '';

		if ($sql) {
			$stmt[''] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['']) {
				if (method_exists($stmt[''], 'get_result')) {
					$result = $stmt['']->get_result();
				} else {
					$result = $this->get_result($stmt['']);
				}
			}

			/*
			if ('' == '_') {
				$value = $this->insertId;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results[''][$row['']] = $values;

							$results[''][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('' == '_') {
					$value = $this->insertId;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results[''] = $this->insertId;
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'UPDATE manufacturer 
			
			SET';

		list($_sql, $_params) = $this->expandList($params['manufacturer_array'], 'manufacturer_array');

		$sql .= ' ' . $_sql;

		if (is_array($_params)) {
			$paramTypes = array_merge($paramTypes, $_params);
		}

		$sql .= ' ' . '
	WHERE manufacturer_id = :manufacturer_id';

		if ($sql) {
			$stmt['manufacturer'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['manufacturer']) {
				if (method_exists($stmt['manufacturer'], 'get_result')) {
					$result = $stmt['manufacturer']->get_result();
				} else {
					$result = $this->get_result($stmt['manufacturer']);
				}
			}

			/*
			if ('manufacturer' == '_') {
				$value = $this->insertId;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('manufacturer' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['manufacturer'][$row['']] = $values;

							$results['manufacturer'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('manufacturer' == '_') {
					$value = $this->insertId;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['manufacturer'] = $this->insertId;
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function addManufacturer($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['manufacturer_data' => 'a'];

		$prevSql = $sql ?? '';
		$sql     = '';

		$filterArray = [
			'manufacturer_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
				'e' => 'auto_increment',
			],
			'name' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'image' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'sort_order' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
			],
		];
		$params['manufacturer']= $this->filter($params['manufacturer_data'], $filterArray,false);

		$sql = '';

		if ($sql) {
			$stmt[''] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['']) {
				if (method_exists($stmt[''], 'get_result')) {
					$result = $stmt['']->get_result();
				} else {
					$result = $this->get_result($stmt['']);
				}
			}

			/*
			if ('' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results[''][$row['']] = $values;

							$results[''][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results[''] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = '';

		$filterArray = [
		];
		$params['manufacturer_description']= $this->filter($params['manufacturer_data'], $filterArray,false);

		$sql = '';

		if ($sql) {
			$stmt[''] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['']) {
				if (method_exists($stmt[''], 'get_result')) {
					$result = $stmt['']->get_result();
				} else {
					$result = $this->get_result($stmt['']);
				}
			}

			/*
			if ('' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results[''][$row['']] = $values;

							$results[''][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results[''] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'INSERT INTO manufacturer 
		
			(';
		$sql .= '`' . implode('`,`', array_keys($params['manufacturer']));
		$sql .= '` )
			
		VALUES ( :manufacturer )';

		if ($sql) {
			$stmt['manufacturer'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['manufacturer']) {
				if (method_exists($stmt['manufacturer'], 'get_result')) {
					$result = $stmt['manufacturer']->get_result();
				} else {
					$result = $this->get_result($stmt['manufacturer']);
				}
			}

			/*
			if ('manufacturer' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('manufacturer' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['manufacturer'][$row['']] = $values;

							$results['manufacturer'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('manufacturer' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['manufacturer'] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'SET @manufacturer_id = LAST_INSERT_ID()';

		if ($sql) {
			$stmt[''] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['']) {
				if (method_exists($stmt[''], 'get_result')) {
					$result = $stmt['']->get_result();
				} else {
					$result = $this->get_result($stmt['']);
				}
			}

			/*
			if ('' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results[''][$row['']] = $values;

							$results[''][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results[''] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'INSERT INTO manufacturer_description 
		
			( `manufacturer_id`,';
		$sql .= '`' . implode('`,`', array_keys($params['manufacturer_description']));
		$sql .= '` )
			
		VALUES ( @manufacturer_id,';

		list($_sql, $_params) = $this->expandList($params['manufacturer_description'], 'manufacturer_description');

		$sql .= ' ' . $_sql;

		if (is_array($_params)) {
			$paramTypes = array_merge($paramTypes, $_params);
		}

		$sql .= ' ' . '
	)';

		if ($sql) {
			$stmt['manufacturer_description'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['manufacturer_description']) {
				if (method_exists($stmt['manufacturer_description'], 'get_result')) {
					$result = $stmt['manufacturer_description']->get_result();
				} else {
					$result = $this->get_result($stmt['manufacturer_description']);
				}
			}

			/*
			if ('manufacturer_description' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('manufacturer_description' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['manufacturer_description'][$row['']] = $values;

							$results['manufacturer_description'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('manufacturer_description' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['manufacturer_description'] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'SELECT @manufacturer_id as manufacturer_id';

		if ($sql) {
			$stmt[''] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['']) {
				if (method_exists($stmt[''], 'get_result')) {
					$result = $stmt['']->get_result();
				} else {
					$result = $this->get_result($stmt['']);
				}
			}

			/*
			if ('' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results[''][$row['']] = $values;

							$results[''][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results[''] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function getManufacturers($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['language_id' => 'i', 'customer_group_id' => 'i', 'store_id' => 'i', 'search' => 's', 'start' => 'i', 'count' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT * FROM manufacturer AS manufacturers
		
			LEFT JOIN manufacturer_to_store p2s ON (manufacturers.manufacturer_id = p2s.manufacturer_id) 
			WHERE p2s.store_id = :store_id';

		if (isset($params['search'])) {
			$sql .= ' AND name LIKE :search ';
		}

		$sql .= ' 
	LIMIT :start, :count';

		if ($sql) {
			$stmt['manufacturers'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['manufacturers']) {
				if (method_exists($stmt['manufacturers'], 'get_result')) {
					$result = $stmt['manufacturers']->get_result();
				} else {
					$result = $this->get_result($stmt['manufacturers']);
				}
			}

			/*
			if ('manufacturers' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('manufacturers' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['manufacturers'][$row['']] = $values;

							$results['manufacturers'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('manufacturers' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['manufacturers'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'SELECT count(*) FROM (';

		$sql .= $this->sqlCount($prevSql, 'manufacturers.manufacturer_id', $this->prefix . 'manufacturer');
		$sql .= '
	
	) as count';

		if ($sql) {
			$stmt['count'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['count']) {
				if (method_exists($stmt['count'], 'get_result')) {
					$result = $stmt['count']->get_result();
				} else {
					$result = $this->get_result($stmt['count']);
				}
			}

			/*
			if ('count' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('count' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['count'][$row['']] = $values;

							$results['count'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('count' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['count'] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}
}
