<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Sql;

class optionsSQL extends \Vvveb\System\Db\mysqli {
	public function __construct() {
		parent::__construct();
	}

	function getOption($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['key' => 's', 'store_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT value
            FROM option AS o
		WHERE o.`key` = :key';

		if ($sql) {
			$stmt['o'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['o']) {
				if (method_exists($stmt['o'], 'get_result')) {
					$result = $stmt['o']->get_result();
				} else {
					$result = $this->get_result($stmt['o']);
				}
			}

			/*
			if ('o' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('o' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['o'][$row['']] = $values;

							$results['o'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('o' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['o'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function setOption($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['key' => 's', 'value' => 'i', 'store_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'INSERT INTO option
            (`key`, `value`, `store_id`)
        
        VALUES ( :key, :value, :store_id )
        
        ON DUPLICATE KEY 
            UPDATE  `value` = values(value)';

		if ($sql) {
			$stmt['value'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['value']) {
				if (method_exists($stmt['value'], 'get_result')) {
					$result = $stmt['value']->get_result();
				} else {
					$result = $this->get_result($stmt['value']);
				}
			}

			/*
			if ('value' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('value' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['value'][$row['']] = $values;

							$results['value'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('value' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['value'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function deleteOption($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['key' => 's', 'value' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'DELETE FROM 
            `option` 
        WHERE `key` = :key';

		if ($sql) {
			$stmt['option'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['option']) {
				if (method_exists($stmt['option'], 'get_result')) {
					$result = $stmt['option']->get_result();
				} else {
					$result = $this->get_result($stmt['option']);
				}
			}

			/*
			if ('option' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('option' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['option'][$row['']] = $values;

							$results['option'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('option' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['option'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function getOptions($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['keys' => 'a', 'store_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT value
            FROM option AS o';

		if (! empty($params['keys'])) {
			$sql .= ' WHERE o.`key` IN (:keys) ';
		}

		if ($sql) {
			$stmt['o'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['o']) {
				if (method_exists($stmt['o'], 'get_result')) {
					$result = $stmt['o']->get_result();
				} else {
					$result = $this->get_result($stmt['o']);
				}
			}

			/*
			if ('o' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('o' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['o'][$row['']] = $values;

							$results['o'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('o' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['o'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function setOptions($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['options' => 'a', 'store_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'INSERT INTO option
            (`key`, `value`, `store_id`)
        
		VALUES ( :each, :store_id)
		ON DUPLICATE KEY 
            UPDATE  `value` = VALUES(value)';

		if ($sql) {
			$stmt['value'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['value']) {
				if (method_exists($stmt['value'], 'get_result')) {
					$result = $stmt['value']->get_result();
				} else {
					$result = $this->get_result($stmt['value']);
				}
			}

			/*
			if ('value' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('value' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['value'][$row['']] = $values;

							$results['value'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('value' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['value'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function deleteOptions($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['keys' => 'a', 'store_id' => 's'];

		$prevSql = $sql ?? '';
		$sql     = 'DELETE FROM 
            `option` 
        WHERE `key` IN (:keys) AND store_id = :store_id';

		if ($sql) {
			$stmt['option'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['option']) {
				if (method_exists($stmt['option'], 'get_result')) {
					$result = $stmt['option']->get_result();
				} else {
					$result = $this->get_result($stmt['option']);
				}
			}

			/*
			if ('option' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('option' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['option'][$row['']] = $values;

							$results['option'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('option' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['option'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}
}
