<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Sql;

class statsSQL extends \Vvveb\System\Db\mysqli {
	public function __construct() {
		parent::__construct();
	}

	function getStats($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['language_id' => 'i', 'store_id' => 'i', 'post_id' => 'i', 'user_id' => 'i', 'start_date' => 's', 'end_date' => 's'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT COUNT(*) AS orders, DATE(date_added) as `date` FROM `order` AS orders
			
				LEFT JOIN order_status AS os ON (orders.order_status_id = os.order_status_id AND os.language_id = :language_id) 
				
			WHERE 1 
			
				AND orders.store_id = :store_id';

		if (isset($params['order_status'])) {
			$sql .= ' AND os.name = :order_status ';
		}

		$sql .= ' 
	GROUP BY DATE(orders.date_added) ORDER BY date';

		if ($sql) {
			$stmt['orders'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['orders']) {
				if (method_exists($stmt['orders'], 'get_result')) {
					$result = $stmt['orders']->get_result();
				} else {
					$result = $this->get_result($stmt['orders']);
				}
			}

			/*
			if ('orders' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('orders' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['orders'][$row['']] = $values;

							$results['orders'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('orders' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['orders'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'SELECT COUNT(*) AS customers, DATE(date_added) as `date` FROM `customer` AS customers
			
			WHERE 1 
			
				AND customers.store_id = :store_id
		
			
				GROUP BY DATE(date_added) ORDER BY date';

		if ($sql) {
			$stmt['customers'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['customers']) {
				if (method_exists($stmt['customers'], 'get_result')) {
					$result = $stmt['customers']->get_result();
				} else {
					$result = $this->get_result($stmt['customers']);
				}
			}

			/*
			if ('customers' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('customers' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['customers'][$row['']] = $values;

							$results['customers'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('customers' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['customers'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}
}
