-- Options

	-- get one option

	CREATE PROCEDURE getOption(
		IN key CHAR,
		IN store_id INT,
	)
	BEGIN

		SELECT value
            FROM option AS o
		WHERE o.`key` = :key;
		
	END
    
	CREATE PROCEDURE setOption(
		IN key CHAR,
		IN value INT,
        IN store_id INT,
	)
	BEGIN

        INSERT INTO option
            (`key`, `value`, `store_id`)
        
        VALUES ( :key, :value, :store_id )
        
        ON DUPLICATE KEY 
            UPDATE  `value` = values(value);
		
	END
    
	CREATE PROCEDURE deleteOption(
		IN key CHAR,
		IN value INT,
	)
	BEGIN

        DELETE FROM 
            `option` 
        WHERE `key` = :key;
		
	END

    CREATE PROCEDURE getOptions(
		IN keys ARRAY,
		IN store_id INT,
	)
	BEGIN

		SELECT value
            FROM option AS o
		
		@IF !empty(:keys) 
		THEN 
			WHERE o.`key` IN (:keys)
		END @IF
		
	END    
    
    
	CREATE PROCEDURE setOptions(
		IN options ARRAY,
		IN store_id INT,
	)
	BEGIN

        INSERT INTO option
            (`key`, `value`, `store_id`)
        
		--@EACH(:options) 
			VALUES ( :each, :store_id)
		--END @EACH	
		
        -- @VALUES(:options) --@VALUES expands the array to the following expression
        --    ( :options.each.key, :options.each.value, :store_id )
        
        ON DUPLICATE KEY 
            UPDATE  `value` = VALUES(value);
		
	END
    
	CREATE PROCEDURE deleteOptions(
		IN keys ARRAY,
		IN store_id,
	)
	BEGIN

        DELETE FROM 
            `option` 
        WHERE `key` IN (:keys) AND store_id = :store_id;
		
	END    