<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Component;

use Vvveb\System\Cart as ShoppingCart;

class Language extends \Vvveb\System\Component {
	public static $designOnly = false;

	public static $defaultOptions = [
		'limit' => [1000, COMPONENT_OPTION_NUMERIC],
		'page'  => [1, COMPONENT_OPTION_NUMERIC],
	];

	public $cacheExpire = 0; //seconds

	function cacheKey() {
		//disable caching
		return false;
	}

	protected $options = [];

	function results() {
		$cart = ShoppingCart::getInstance();

		if (isset($this->request->get['product_id'])) {
			$cart->add($this->request->get['product_id']);
		}

		$results = $cart->getProducts();
		$results = $cart->cart;

		return $results;
	}
}
