<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Component;

use Vvveb\System\Images as Images;

class Page extends \Vvveb\System\Component {
	public static $designOnly = false;

	public static $defaultOptions = [
		'post_id'     => 'url',
		'slug'        => 'url',
		'language_id' => 1,
		'store_id'    => 0,
	];

	function results() {
		$page = new \Vvveb\Sql\PostsSQL();

		$results = $page->getPost($this->options);

		if (isset($results['images'])) {
			$results['images'] = Images::images('page', $results['images']);
		}

		if (isset($results['image'])) {
			$results['images'][] = Images::image('page', $results['image']);
		}

		return $results;
	}
}
