<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Component;

use Vvveb\System\Images as Images;

class Posts extends \Vvveb\System\Component {
	public static $designOnly = false;

	public static $defaultOptions = [
		'page'        => 1,
		'language_id' => 1,
		'store_id'    => 0,
		'post_id'     => 'url',
		'source'      => 'autocomplete',
		'type'        => 'post',
		'limit'       => ['url', 4],
		'order_by'    => 'url',
		'direction'   => ['url', 'asc'],
		'category_id' => NULL,
		'id'          => NULL,
		'search'      => NULL,
	];

	public $options = [];

	function __construct($options) {
		return parent::__construct($options);
	}

	function results() {
		$posts = new \Vvveb\Sql\PostsSQL();

		if ($page = $this->options['page']) {
			$this->options['start'] = ($page - 1) * $this->options['limit'];
		}

		if (isset($this->options['post_id']) && is_array($this->options['post_id']) && $this->options['source'] == 'autocomplete') {
			$this->options['post_id'] = array_keys($this->options['post_id']);
		} else {
			$this->options['post_id'] = [];
		}

		if (isset($this->options['order_by']) &&
				! in_array($this->options['order_by'], ['date_added', 'date_modified'])) {
			unset($this->options['order_by']);
		}

		if (isset($this->options['direction']) &&
				! in_array($this->options['direction'], ['asc', 'desc'])) {
			unset($this->options['direction']);
		}

		$results = $posts->getPosts($this->options);

		foreach ($results['posts'] as $id => &$post) {
			if (isset($post['images'])) {
				$post['images'] = json_decode($post['images'], 1);

				foreach ($post['images'] as &$image) {
					$image = Images::image('post', $image);
				}
			}

			if (isset($post['image'])) {
				$post['images'][] = Images::image('post', $post['image']);
			}
		}

		return $results;
	}
}
