<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Component;

use Vvveb\System\Images as Images;

class Products extends \Vvveb\System\Component {
	public static $designOnly = false;

	public static $defaultOptions = [
		'start'                 => 0,
		'page'                  => NULL,
		'language_id'           => 1,
		'store_id'              => 0,
		'count'                 => ['url', 4],
		'parent'                => null,
		'id_manufacturer'       => NULL,
		'order'                 => ['url', 'price asc'],
		'category_id'           => NULL,
		'include_image_gallery' => true,
		'id'                    => NULL,
		'products'              => [],
		'manufacturer'          => [],
		'category'              => [],
	];

	public $options = [];

	function __construct($options) {
		return parent::__construct($options);
	}

	function cacheKey() {
		//disable caching
		return false;
	}

	function results() {
		$products = new \Vvveb\Sql\ProductsSQL();

		if ($page = $this->options['page']) {
			$this->options['start'] = ($page - 1) * $this->options['count'];
		}

		$results = $products->getProducts($this->options);

		foreach ($results['products'] as $id => &$product) {
			if (isset($product['images'])) {
				//$product['images'] = json_decode($product['images'], true);
				$product['images'] = explode(',', $product['images']);

				foreach ($product['images'] as &$image) {
					$image = Images::image('product', $image);
				}
			}

			if (isset($product['image'])) {
				$product['images'][] = Images::image('product', $product['image']);
			}
		}

		return $results;
	}
}
