<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Sql;

class categoriesSQL extends \Vvveb\System\Db\mysqli {
	public function __construct() {
		parent::__construct();
	}

	function getCategories($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['language_id' => 'i', 'store_id' => 'i', 'search' => 's', 'start' => 'i', 'count' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT  SQL_CALC_FOUND_ROWS *

		FROM category AS categories
		
			LEFT JOIN category_to_store c2s ON (categories.category_id = c2s.category_id) 
			LEFT JOIN category_description pd ON (categories.category_id = pd.category_id)  

			WHERE 
			
			pd.language_id = :language_id AND c2s.store_id = :store_id';

		if (isset($params['search'])) {
			$sql .= ' AND pd.name LIKE :search ';
		}

		$sql .= ' 
	LIMIT :start, :count';

		if ($sql) {
			$stmt['categories'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['categories']) {
				if (method_exists($stmt['categories'], 'get_result')) {
					$result = $stmt['categories']->get_result();
				} else {
					$result = $this->get_result($stmt['categories']);
				}
			}

			/*
			if ('categories' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('categories' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['categories'][$row['']] = $values;

							$results['categories'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('categories' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['categories'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'SELECT FOUND_ROWS() as count';

		if ($sql) {
			$stmt['count'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['count']) {
				if (method_exists($stmt['count'], 'get_result')) {
					$result = $stmt['count']->get_result();
				} else {
					$result = $this->get_result($stmt['count']);
				}
			}

			/*
			if ('count' == '_') {
				$value = $result->fetch_array(MYSQLI_NUM)[0];
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('count' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['count'][$row['']] = $values;

							$results['count'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('count' == '_') {
					$value = $result->fetch_array(MYSQLI_NUM)[0];

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['count'] = $result->fetch_array(MYSQLI_NUM)[0];
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function getCategory($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['language_id' => 'i', 'store_id' => 'i', 'category_id' => 'i', 'slug' => 's'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT  SQL_CALC_FOUND_ROWS *

		FROM category AS _
		
			LEFT JOIN category_to_store c2s ON (_.category_id = c2s.category_id) 
			LEFT JOIN category_description pd ON (_.category_id = pd.category_id)  

			WHERE 
			
			pd.language_id = :language_id AND c2s.store_id = :store_id';

		if (isset($params['slug'])) {
			$sql .= ' AND pd.slug = :slug ';
		}

		if (isset($params['category_id'])) {
			$sql .= ' AND _.category_id = :category_id ';
		}

		$sql .= ' 
	LIMIT 1';

		if ($sql) {
			$stmt['_'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['_']) {
				if (method_exists($stmt['_'], 'get_result')) {
					$result = $stmt['_']->get_result();
				} else {
					$result = $this->get_result($stmt['_']);
				}
			}

			/*
			if ('_' == '_') {
				$value = $result->fetch_array(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('_' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['_'][$row['']] = $values;

							$results['_'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('_' == '_') {
					$value = $result->fetch_array(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['_'] = $result->fetch_array(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function editCategory($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['category_data' => 'a', 'category_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'DELETE FROM category_description WHERE category_id = :category_id';

		if ($sql) {
			$stmt['category_description'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['category_description']) {
				if (method_exists($stmt['category_description'], 'get_result')) {
					$result = $stmt['category_description']->get_result();
				} else {
					$result = $this->get_result($stmt['category_description']);
				}
			}

			/*
			if ('category_description' == '_') {
				$value = $this->insertId;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('category_description' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['category_description'][$row['']] = $values;

							$results['category_description'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('category_description' == '_') {
					$value = $this->insertId;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['category_description'] = $this->insertId;
				}
			}
			//}
		}

		$prevSql = $sql ?? '';

		foreach ($params['category_data']['category_description'] as $key => $rowParent) {
			$params['each']     = $rowParent;
			$paramTypes['each'] = 'a';
			$sql                = 'INSERT INTO category_description 
		
				(';
			$sql .= '`' . implode('`,`', array_keys($params['each']));
			$sql .= '` , category_id )
			
			VALUES ( :each, :category_id)';

			if ($sql) {
				$stmt['category_description'] = $this->execute($sql, $params, $paramTypes);

				$result = false;

				if ($stmt['category_description']) {
					if (method_exists($stmt['category_description'], 'get_result')) {
						$result = $stmt['category_description']->get_result();
					} else {
						$result = $this->get_result($stmt['category_description']);
					}
				}

				/*
				if ('category_description' == '_') {
					$value = $this->insertId;
					if (is_array($value))
					{
						$results = $results + $value;
					} else
					{
						$results = $value;
					}
				} else { */
				if (! empty('')) {
					if ($result) {
						while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
							$values = $row;

							if (! empty('')) {
								//$values = $row[''];
								$values = $row['array_value'];
							}

							if ('category_description' == '_') {
								//$results[$row['']] = $values;
								$results[$row['array_key']] = $values;
							} else {
								//$results['category_description'][$row['']] = $values;

								$results['category_description'][$row['array_key']] = $values;
							}
						}
					}
				} else {
					if ('category_description' == '_') {
						$value = $this->insertId;

						if (is_array($value)) {
							$results = $results + $value;
						} else {
							$results = $value;
						}
					} else {
						$results['category_description'] = $this->insertId;
					}
				}
				//}
			}
		}
		unset($params['each'], $paramTypes['each']);

		$prevSql = $sql ?? '';
		$sql     = '';

		$filterArray = [
			'category_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
				'e' => 'auto_increment',
			],
			'image' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'parent_id' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'top' => [
				'd' => '0',
				'n' => false,
				't' => 'tinyint',
			],
			'column' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'sort_order' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'status' => [
				'd' => '0',
				'n' => false,
				't' => 'tinyint',
			],
			'date_added' => [
				'd' => 'current_timestamp()',
				'n' => false,
				't' => 'datetime',
			],
			'date_modified' => [
				'd' => 'current_timestamp()',
				'n' => false,
				't' => 'datetime',
			],
		];
		$params['category_data']= $this->filter($params['category_data'], $filterArray,false);

		$sql = '';

		if ($sql) {
			$stmt[''] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['']) {
				if (method_exists($stmt[''], 'get_result')) {
					$result = $stmt['']->get_result();
				} else {
					$result = $this->get_result($stmt['']);
				}
			}

			/*
			if ('' == '_') {
				$value = $this->insertId;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results[''][$row['']] = $values;

							$results[''][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('' == '_') {
					$value = $this->insertId;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results[''] = $this->insertId;
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'UPDATE category 
			
			SET';

		list($_sql, $_params) = $this->expandList($params['category_data'], 'category_data');

		$sql .= ' ' . $_sql;

		if (is_array($_params)) {
			$paramTypes = array_merge($paramTypes, $_params);
		}

		$sql .= ' ' . '
	WHERE category_id = :category_id';

		if ($sql) {
			$stmt['category'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['category']) {
				if (method_exists($stmt['category'], 'get_result')) {
					$result = $stmt['category']->get_result();
				} else {
					$result = $this->get_result($stmt['category']);
				}
			}

			/*
			if ('category' == '_') {
				$value = $this->insertId;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('category' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['category'][$row['']] = $values;

							$results['category'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('category' == '_') {
					$value = $this->insertId;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['category'] = $this->insertId;
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function addCategory($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['category_data' => 'a', 'store_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = '';

		$filterArray = [
			'category_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
				'e' => 'auto_increment',
			],
			'image' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'parent_id' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'top' => [
				'd' => '0',
				'n' => false,
				't' => 'tinyint',
			],
			'column' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'sort_order' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'status' => [
				'd' => '0',
				'n' => false,
				't' => 'tinyint',
			],
			'date_added' => [
				'd' => 'current_timestamp()',
				'n' => false,
				't' => 'datetime',
			],
			'date_modified' => [
				'd' => 'current_timestamp()',
				'n' => false,
				't' => 'datetime',
			],
		];
		$params['category']= $this->filter($params['category_data'], $filterArray,false);

		$sql = '';

		$filterArray = [
			'category_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
			],
			'language_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'int',
			],
			'name' => [
				'd' => NULL,
				'n' => false,
				't' => 'varchar',
			],
			'slug' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'description' => [
				'd' => NULL,
				'n' => false,
				't' => 'text',
			],
			'meta_title' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'meta_description' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'meta_keyword' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
		];
		$params['category_description']= $this->filter($params['category_data'], $filterArray,false);

		$sql = 'INSERT INTO category 
		
			(';
		$sql .= '`' . implode('`,`', array_keys($params['category']));
		$sql .= '` )
			
		VALUES ( :category )';

		if ($sql) {
			$stmt['category'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['category']) {
				if (method_exists($stmt['category'], 'get_result')) {
					$result = $stmt['category']->get_result();
				} else {
					$result = $this->get_result($stmt['category']);
				}
			}

			/*
			if ('category' == '_') {
				$value = $this->insertId;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('category' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['category'][$row['']] = $values;

							$results['category'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('category' == '_') {
					$value = $this->insertId;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['category'] = $this->insertId;
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'INSERT INTO category_to_store 
		
			( `category_id`, `store_id`)
			
		VALUES ( ' . ($results['category'] ?? 'NULL') . ', :store_id )';

		if ($sql) {
			$stmt['category_to_store'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['category_to_store']) {
				if (method_exists($stmt['category_to_store'], 'get_result')) {
					$result = $stmt['category_to_store']->get_result();
				} else {
					$result = $this->get_result($stmt['category_to_store']);
				}
			}

			/*
			if ('category_to_store' == '_') {
				$value = $this->insertId;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('category_to_store' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['category_to_store'][$row['']] = $values;

							$results['category_to_store'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('category_to_store' == '_') {
					$value = $this->insertId;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['category_to_store'] = $this->insertId;
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'INSERT INTO category_description 
		
			( `category_id`,';
		$sql .= '`' . implode('`,`', array_keys($params['category_description']));
		$sql .= '` )
			
		VALUES ( ' . ($results['category'] ?? 'NULL') . ', :category_description )';

		if ($sql) {
			$stmt['category_description'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['category_description']) {
				if (method_exists($stmt['category_description'], 'get_result')) {
					$result = $stmt['category_description']->get_result();
				} else {
					$result = $this->get_result($stmt['category_description']);
				}
			}

			/*
			if ('category_description' == '_') {
				$value = isset($results['category']) ? $results['category'] : 'NULL';
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('category_description' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['category_description'][$row['']] = $values;

							$results['category_description'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('category_description' == '_') {
					$value = $results['category'] ?? 'NULL';

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['category_description'] = $results['category'] ?? 'NULL';
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}
}
