<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\Sql;

class commentsSQL extends \Vvveb\System\Db\mysqli {
	public function __construct() {
		parent::__construct();
	}

	function getComments($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['start' => 'i', 'limit' => 'i', 'post_id' => 'i', 'user_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT SQL_CALC_FOUND_ROWS *
		FROM comment AS comments
			WHERE 1';

		if (isset($params['post_id'])) {
			$sql .= ' AND comments.post_id  = :post_id ';
		}

		if (isset($params['user_id'])) {
			$sql .= ' AND comments.user_id  = :user_id ';
		}

		$sql .= ' 
	LIMIT :start, :limit';

		if ($sql) {
			$stmt['comments'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['comments']) {
				if (method_exists($stmt['comments'], 'get_result')) {
					$result = $stmt['comments']->get_result();
				} else {
					$result = $this->get_result($stmt['comments']);
				}
			}

			/*
			if ('comments' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('comments' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['comments'][$row['']] = $values;

							$results['comments'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('comments' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['comments'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function getComment($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['comment_id' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'SELECT * 
			FROM comment AS _
		WHERE 
			
			1';

		if (isset($params['comment_id'])) {
			$sql .= ' AND _.comment_id = :comment_id ';
		}

		$sql .= ' 
	LIMIT 1';

		if ($sql) {
			$stmt['_'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['_']) {
				if (method_exists($stmt['_'], 'get_result')) {
					$result = $stmt['_']->get_result();
				} else {
					$result = $this->get_result($stmt['_']);
				}
			}

			/*
			if ('_' == '_') {
				$value = $result->fetch_array(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('_' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['_'][$row['']] = $values;

							$results['_'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('_' == '_') {
					$value = $result->fetch_array(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['_'] = $result->fetch_array(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function addComment($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['comment' => 'a'];

		$prevSql = $sql ?? '';
		$sql     = '';

		$filterArray = [
			'comment_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'bigint',
				'e' => 'auto_increment',
			],
			'post_id' => [
				'd' => '0',
				'n' => false,
				't' => 'bigint',
			],
			'author' => [
				'd' => NULL,
				'n' => false,
				't' => 'tinytext',
			],
			'email' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'url' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'ip' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'date' => [
				'd' => '\'1000-01-01 00:00:00\'',
				'n' => false,
				't' => 'datetime',
			],
			'date_gmt' => [
				'd' => '\'1000-01-01 00:00:00\'',
				'n' => false,
				't' => 'datetime',
			],
			'content' => [
				'd' => NULL,
				'n' => false,
				't' => 'text',
			],
			'karma' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'approved' => [
				'd' => '\'1\'',
				'n' => false,
				't' => 'varchar',
			],
			'agent' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'type' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'parent' => [
				'd' => '0',
				'n' => false,
				't' => 'bigint',
			],
			'user_id' => [
				'd' => '0',
				'n' => false,
				't' => 'bigint',
			],
		];
		$params['comment']= $this->filter($params['comment'], $filterArray,false);

		$sql = 'INSERT INTO comment 
			
			(';
		$sql .= '`' . implode('`,`', array_keys($params['comment']));
		$sql .= '` )
			
	  	VALUES ( ';

		list($_sql, $_params) = $this->expandArray($params['comment'], 'comment');

		$sql .= $_sql;

		if (is_array($_params)) {
			$paramTypes = array_merge($paramTypes, $_params);
		}

		$sql .= ' )';

		if ($sql) {
			$stmt['comment'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['comment']) {
				if (method_exists($stmt['comment'], 'get_result')) {
					$result = $stmt['comment']->get_result();
				} else {
					$result = $this->get_result($stmt['comment']);
				}
			}

			/*
			if ('comment' == '_') {
				$value = $this->insertId;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('comment' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['comment'][$row['']] = $values;

							$results['comment'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('comment' == '_') {
					$value = $this->insertId;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['comment'] = $this->insertId;
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function editComment($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['comment' => 'a', 'id_comment' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = '';

		$filterArray = [
			'comment_id' => [
				'd' => NULL,
				'n' => false,
				't' => 'bigint',
				'e' => 'auto_increment',
			],
			'post_id' => [
				'd' => '0',
				'n' => false,
				't' => 'bigint',
			],
			'author' => [
				'd' => NULL,
				'n' => false,
				't' => 'tinytext',
			],
			'email' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'url' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'ip' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'date' => [
				'd' => '\'1000-01-01 00:00:00\'',
				'n' => false,
				't' => 'datetime',
			],
			'date_gmt' => [
				'd' => '\'1000-01-01 00:00:00\'',
				'n' => false,
				't' => 'datetime',
			],
			'content' => [
				'd' => NULL,
				'n' => false,
				't' => 'text',
			],
			'karma' => [
				'd' => '0',
				'n' => false,
				't' => 'int',
			],
			'approved' => [
				'd' => '\'1\'',
				'n' => false,
				't' => 'varchar',
			],
			'agent' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'type' => [
				'd' => '\'\'',
				'n' => false,
				't' => 'varchar',
			],
			'parent' => [
				'd' => '0',
				'n' => false,
				't' => 'bigint',
			],
			'user_id' => [
				'd' => '0',
				'n' => false,
				't' => 'bigint',
			],
		];
		$params['comment']= $this->filter($params['comment'], $filterArray,false);

		$sql = '';

		if ($sql) {
			$stmt[''] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['']) {
				if (method_exists($stmt[''], 'get_result')) {
					$result = $stmt['']->get_result();
				} else {
					$result = $this->get_result($stmt['']);
				}
			}

			/*
			if ('' == '_') {
				$value = $this->insertId;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results[''][$row['']] = $values;

							$results[''][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('' == '_') {
					$value = $this->insertId;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results[''] = $this->insertId;
				}
			}
			//}
		}

		$prevSql = $sql ?? '';
		$sql     = 'UPDATE comment 
			
			SET';

		list($_sql, $_params) = $this->expandList($params['comment'], 'comment');

		$sql .= ' ' . $_sql;

		if (is_array($_params)) {
			$paramTypes = array_merge($paramTypes, $_params);
		}

		$sql .= ' ' . '
	WHERE comment_id = :id_comment';

		if ($sql) {
			$stmt['comment'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['comment']) {
				if (method_exists($stmt['comment'], 'get_result')) {
					$result = $stmt['comment']->get_result();
				} else {
					$result = $this->get_result($stmt['comment']);
				}
			}

			/*
			if ('comment' == '_') {
				$value = $this->insertId;
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('comment' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['comment'][$row['']] = $values;

							$results['comment'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('comment' == '_') {
					$value = $this->insertId;

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['comment'] = $this->insertId;
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}

	function deleteComment($params = []) {
		//multitple
		$results    = [];
		$stmt       = [];
		$paramTypes = ['id_comment' => 'i'];

		$prevSql = $sql ?? '';
		$sql     = 'DELETE FROM comment WHERE comment_id = :id_comment';

		if ($sql) {
			$stmt['comment'] = $this->execute($sql, $params, $paramTypes);

			$result = false;

			if ($stmt['comment']) {
				if (method_exists($stmt['comment'], 'get_result')) {
					$result = $stmt['comment']->get_result();
				} else {
					$result = $this->get_result($stmt['comment']);
				}
			}

			/*
			if ('comment' == '_') {
				$value = $result->fetch_all(MYSQLI_ASSOC);
				if (is_array($value))
				{
					$results = $results + $value;
				} else
				{
					$results = $value;
				}
			} else { */
			if (! empty('')) {
				if ($result) {
					while ($row = $result->fetch_array(MYSQLI_ASSOC)) {
						$values = $row;

						if (! empty('')) {
							//$values = $row[''];
							$values = $row['array_value'];
						}

						if ('comment' == '_') {
							//$results[$row['']] = $values;
							$results[$row['array_key']] = $values;
						} else {
							//$results['comment'][$row['']] = $values;

							$results['comment'][$row['array_key']] = $values;
						}
					}
				}
			} else {
				if ('comment' == '_') {
					$value = $result->fetch_all(MYSQLI_ASSOC);

					if (is_array($value)) {
						$results = $results + $value;
					} else {
						$results = $value;
					}
				} else {
					$results['comment'] = $result->fetch_all(MYSQLI_ASSOC);
				}
			}
			//}
		}

		if ($results) {
			return $results;
		}
	}
}
