-- Options

	-- get one option

	CREATE PROCEDURE get(
		IN key CHAR,
		IN store_id INT,
	)
	BEGIN

		SELECT value
            FROM option AS o
		WHERE o.`key` = :key;
		
	END
    
	CREATE PROCEDURE set(
		IN key CHAR,
		IN value INT,
        IN store_id INT,
	)
	BEGIN

        INSERT INTO option
            (`key`, `value`, `store_id`)
        
        VALUES ( :key, :value, :store_id )
        
        ON DUPLICATE KEY 
            UPDATE  `value` = values(value);
		
	END
    
	CREATE PROCEDURE delete(
		IN key CHAR,
		IN value INT,
	)
	BEGIN

        DELETE FROM 
            `option` 
        WHERE `key` = :key;
		
	END

    CREATE PROCEDURE getOptions(
		IN keys ARRAY,
		IN store_id INT,
	)
	BEGIN

		SELECT value
            FROM option AS o
		WHERE o.`key` IN :keys;
		
	END    
    
    
	CREATE PROCEDURE setOptions(
		IN options ARRAY,
		IN store_id INT,
	)
	BEGIN

        INSERT INTO option
            (`key`, `value`, `store_id`)
        
        VALUES 
        
        @EACH(:options) 
            ( :options.key, :options.value :store_id )
        
        ON DUPLICATE KEY 
            UPDATE  `value` = values(value);
		
	END
    
	CREATE PROCEDURE deleteOptions(
		IN keys ARRAY,
		IN store_id,
	)
	BEGIN

        DELETE FROM 
            `option` 
        WHERE `key` IN :keys AND store_id = :store_id;
		
	END    