import {ServerComponent} from '../server-component.js';

class PostsComponent extends ServerComponent{
	constructor ()
	{
		super();

		this.name = "Posts";
		this.attributes = ["data-v-component-posts"],

		this.image ="icons/posts.svg";
		this.html = '<div class="form-group"><label>Your response:</label><textarea class="form-control"></textarea></div>';
		
		this.properties = [{
			name: false,
			key: "source",
			inputtype: RadioButtonInput,
			htmlAttr:"data-v-source",
			data: {
				inline: true,
				extraclass:"btn-group-fullwidth",
				options: [{
					value: "autocomplete",
					text: "Autocomplete",
					title: "Autocomplete",
					icon:"la la-search",
					extraclass:"btn-sm",
					checked:true,
				}, {
					value: "automatic",
					icon:"la la-cog",
					text: "Configuration",
					title: "Configuration",
					extraclass:"btn-sm",
				}],
			},
			
			setGroup: group => {
				$('.form-group[data-group]').attr('style','display:none !important');
				$('.form-group[data-group="'+ group + '"]').attr('style','');
				//return element;
			}, 		
			onChange : function(element, value, input)  {
				this.setGroup(input.value);
				return element;
			}, 
			init: function (node) {
				//this.setGroup(node.dataset.vSource);
				//return 'autocomplete';
				return node.dataset.vSource;
			},            
		},{
			name: "Posts",
			key: "posts",
			group:"autocomplete",
			htmlAttr:"data-v-post_id",
			inline:true,
			col:12,
			inputtype: AutocompleteList,
			data: {
				url: "/admin/?module=editor/autocomplete&action=posts",
			},
		},{
			name: "Nr. of posts",
			group:"automatic",
			col:6,
			inline:true,
			key: "limit",
			htmlAttr:"data-v-limit",
			inputtype: NumberInput,
			data: {
				value: "8",//default
				min: "1",
				max: "1024",
				step: "1"
			},        
		},{
			name: "Start from page",
			group:"automatic",
			col:6,
			inline:true,
			key: "page",
			htmlAttr:"data-v-page",
			data: {
				value: "1",//default
				min: "1",
				max: "1024",
				step: "1"
			},        
			inputtype: NumberInput,
		},{
			name: "Order by",
			group:"automatic",
			key: "order",
			col:6,
			inline:true,
			htmlAttr:"data-v-order_by",
			inputtype: SelectInput,
			data: {
				options: [{
					value: "NULL",
					text: "Default"
				}, {
					value: "date_added",
					text: "Date added"
				}, {
					value: "date_modified",
					text: "Date modified"
				}/*, {
					value: "sales",
					text: "Sales"
				}*/]
			}
		},{	
			name: "Order direction",
			group:"automatic",
			key: "order",
			col:6,
			inline:true,
			htmlAttr:"data-v-direction",
			inputtype: SelectInput,
			data: {
				options: [{
					value: "asc",
					text: "Ascending"
				}, {
					value: "desc",
					text: "Descending"
				}]
			}
		},{
			name: "Limit to categories",
			group:"automatic",
			key: "category",
			htmlAttr:"data-v-category",
			inline:true,
			col:12,
			inputtype: TagsInput,
			data: {
				url: "/admin/?module=editor/autocomplete&action=categories",
			},

		},{
			name: "Limit to manufacturers",
			group:"automatic",
			key: "manufacturer",
			htmlAttr:"data-v-manufacturer",
			inline:true,
			col:12,
			inputtype: TagsInput,
			data: {
				url: "/admin/?module=editor/autocomplete&action=manufacturers",
			}
		}];
	}

    init(node)
	{
		console.log(node);
		$('.form-group[data-group]').attr('style','display:none !important');
		
		if (node.dataset.vSource != undefined)
		{
			$('.form-group[data-group="'+ node.dataset.vSource + '"]').attr('style','');
		} else
		{		
			$('.form-group[data-group]:first').attr('style','');
		}
	}
}

let postsComponent = new PostsComponent;

export {
  postsComponent
};
