class ProductComponent {
	constructor ()
	{
		this.name = "Product";
		this.attributes = ["data-v-component-product"],

		this.image ="icons/product.svg";
		this.html = '<div class="form-group"><label>Your response:</label><textarea class="form-control"></textarea></div>';
		
		this.properties = [{
			name: false,
			key: "type",
			inputtype: RadioButtonInput,
			htmlAttr:"data-v-type",
			data: {
				inline: true,
				extraclass:"btn-group-fullwidth",
				options: [{
					value: "autocomplete",
					text: "Autocomplete import",
					title: "Autocomplete",
					icon:"la la-search",
					extraclass:"btn-sm",
					checked:true,
				}, {
					value: "automatic",
					icon:"la la-cog",
					text: "Configuration",
					title: "Configuration",
					extraclass:"btn-sm",
				}],
			},
			
			setGroup: group => {
				$('.form-group[data-v-group]').attr('style','display:none !important');
				$('.form-group[data-v-group="'+ group + '"]').attr('style','');

				return element;
			}, 		
			onChange : function(element, value, input)  {
				this.setGroup(input.value);

				return element;
			}, 
			init: node => {
				console.log(node, 'init');
				//return this.setGroup('autocomplete');
				//return 'autocomplete';
				return node.dataset.type;
			},            
		},{
			name: "Product",
			key: "product",
			group:"autocomplete",
			htmlAttr:"data-v-product",
			inline:true,
			col:12,
			inputtype: AutocompleteList,
			data: {
				url: "/admin/?module=editor/editor&action=productAutocomplete",
			},
		},{
			name: "Nr. of product",
			group:"automatic",
			col:6,
			inline:true,
			key: "limit",
			htmlAttr:"data-v-limit",
			inputtype: NumberInput,
			data: {
				value: "8",//default
				min: "1",
				max: "1024",
				step: "1"
			},        
			getFromNode: node => 10
			,
		},{
			name: "Start from page",
			group:"automatic",
			col:6,
			inline:true,
			key: "page",
			htmlAttr:"data-v-page",
			data: {
				value: "1",//default
				min: "1",
				max: "1024",
				step: "1"
			},        
			inputtype: NumberInput,
			getFromNode: node =>  0,
		},{
			name: "Order by",
			group:"automatic",
			key: "order",
			htmlAttr:"data-v-order",
			inputtype: SelectInput,
			data: {
				options: [{
					value: "price_asc",
					text: "Price Ascending"
				}, {
					value: "price_desc",
					text: "Price Descending"
				}, {
					value: "date_asc",
					text: "Date Ascending"
				}, {
					value: "date_desc",
					text: "Date Descending"
				}, {
					value: "sales_asc",
					text: "Sales Ascending"
				}, {
					value: "sales_desc",
					text: "Sales Descending"
				}]
			}
		},{
			name: "Category",
			group:"automatic",
			key: "category",
			htmlAttr:"data-v-category",
			inline:true,
			col:12,
			inputtype: TagsInput,
			data: {
				url: "/admin/?module=editor&action=productAutocomplete",
			},

		},{
			name: "Manufacturer",
			group:"automatic",
			key: "manufacturer",
			htmlAttr:"data-v-manufacturer",
			inline:true,
			col:12,
			inputtype: TagsInput,
			data: {
				url: "/admin/?module=editor&action=productAutocomplete",
			}
		},{
			name: "Manufacturer 2",
			group:"automatic",
			key: "manufacturer 2",
			htmlAttr:"data-v-manufacturer2",
			inline:true,
			col:12,
			inputtype: TagsInput,
			data: {
				url: "/admin/?module=editor&action=productAutocomplete",
			},
		}];
	}

    init(node)
	{
		$('.form-group[data-v-group]').attr('style','display:none !important');
		if (node.dataset.type != undefined)
		{
			$('.form-group[data-v-group="'+ node.dataset.type + '"]').attr('style','');
		} else
		{		
			$('.form-group[data-v-group]:first').attr('style','');
		}
	}
}

let productComponent = new ProductComponent;

export {
  productComponent
};
