<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\System;

class Config {
	private $config = [];

	private static $instance;

	public static function getInstance() {
		if (self::$instance) {
			return self::$instance;
		} else {
			return self::$instance = new self();
		}
	}

	function __construct() {
		$files = glob(DIR_ROOT . '/config/*.php');

		foreach ($files as $file) {
			$namespace                = Str::match('@/([^\.\/]+)\.php$@',$file);
			$this->config[$namespace] = include $file;
		}
	}

	public function get($key, $default = null) {
		return \Vvveb\arrayPath($this->config, $key, $default);
	}

	public function set($key, $value) {
		$this->config[$key] = $value;
	}
}
