<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb;

define('SQLP_DRIVER', 'MYSQL');
/*
define('SQLP_VAR_REGEX', 
	'/:(\w+)/ms');
*/

if (! class_exists('Db')) {
	class Db {
		private $host      = DB_HOST;

		private $user      = DB_USER;

		private $pass      = DB_PASS;

		private $dbname    = DB_NAME;

		private $db;

		private $error;

		private $stmt;

		public function __construct() {
			if (SQLP_DRIVER == 'MYSQL') {
				// Create a new PDO instanace
				try {
					$this->db = new mysqli($this->host, $this->user, $this->pass, $this->dbname);
				}
				// Catch any errors
				catch (\Exception $e) {
					$this->error = $e->getMessage();
				}
			}
		}

		// Prepare
		public function execute($sql, $params, $paramTypes) {
			if (SQLP_DRIVER == 'MYSQL') {
				$types      = '';
				$parameters = [];
				$sql        = preg_replace_callback(
			SQLP_VAR_REGEX,
			function ($matches) use ($params, &$parameters, &$types, $paramTypes) {
				if (isset($params[$matches[1]])) {
					$type = $paramTypes[$matches[1]];

					if (! $type) {
						$type = 's';
					}
					$types .= $type;
					$parameters[] = &$params[$matches[1]];
				} else {
					return 'null';
				}

				return '?';
			},
			$sql);

				//if (!$stmt) var_dump($stmt->error);

				/*			var_dump($sql);
							var_dump($types);
							var_dump($parameters);*/

				$stmt = $this->db->prepare($sql);

				if (! empty($types)) {
					array_unshift($parameters, $types);
					call_user_func_array([$stmt, 'bind_param'], $parameters);
				}

				if ($stmt->execute()) {
					//var_dump($stmt);
					return $stmt;
				} else {
					var_dump($stmt->error);
				}
			}
		}

		public function query($query) {
			$this->stmt = $this->db->prepare($query);
		}

		// Bind
		public function bind($param, $value, $type = null) {
			$this->stmt->bindValue($param, $value, $type);
		}

		/*		
			public function bind($param, $value, $type = null){
				if (is_null($type)) {
					switch (true) {
						case is_int($value):
							$type = PDO::PARAM_INT;
							break;
						case is_bool($value):
							$type = PDO::PARAM_BOOL;
							break;
						case is_null($value):
							$type = PDO::PARAM_NULL;
							break;
						default:
							$type = PDO::PARAM_STR;
					}
				}
				$this->stmt->bindValue($param, $value, $type);
			}
			*/
	}
}
