<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\System;

class Images {
	public function __construct() {
	}

	static public function image($type, $file = '') {
		if ($file) {
			return '/public/media/' . $file;
		} else {
			return '/public/media/placeholder.png';
		}
	}

	static public function images($type, $images) {
		foreach ($images as $key => &$image) {
			$image['image'] = Images::image($type, $image['image']);
		}

		uasort($images, function ($a, $b) {
			if ($a['sort_order'] == $b['sort_order']) {
				return 0;
			}

			return ($a['sort_order'] < $b['sort_order']) ? -1 : 1;
		});

		return $images;
	}

	public function get($type, $id, $size, $attrs) {
	}

	public function save($type, $path, $attrs) {
	}
}
