<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\System;

class Request {
	public $get = [];

	public $post = [];

	public $request = [];

	public $cookie = [];

	public $files = [];

	public $server = [];

	protected static $instance;

	public static function getInstance() {
		if (is_null(static::$instance)) {
			static::$instance = new static();
		}

		return static::$instance;
	}

	private function __construct() {
		$this->get     = $this->filter($_GET);
		$this->post    = $this->filter($_POST);
		$this->request = $this->filter($_REQUEST);
		$this->cookie  = $this->filter($_COOKIE);
		$this->files   = $this->filter($_FILES);
		$this->server  = $_SERVER;

		$this->request = array_merge($this->request, $this->get, $this->post);
	}

	public function filter($data) {
		if (is_array($data)) {
			foreach ($data as $key => $value) {
				unset($data[$key]);
				$key = substr($this->filter($key), 0, 255);

				$data[$key] = $this->filter($value);
			}
		} else {
			$data = urldecode(filter_var($data,FILTER_SANITIZE_STRING, FILTER_FLAG_ENCODE_HIGH | FILTER_FLAG_ENCODE_LOW));
			//$data = htmlspecialchars($data, ENT_COMPAT, 'UTF-8');
		}

		return $data;
	}
}
