<?php

/**
 * Vvveb
 *
 * Copyright (C) 2020  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

namespace Vvveb\System;

class Session extends \SessionHandler {
	private static $lifetime = 0;

	static $data;

	static $canStart = false;

	public function open($path, $name) {
		self::$lifetime = ini_get('session.gc_maxlifetime');

		return true;
	}

	public function read($id) {
		include 'memcache.php';
		$sessionKey = '_session_' . $id;
		$memcache   = Memcache::getInstance();

		if (! $data = $memcache->atomic($sessionKey, 3600,
						  function () {
						  	return session :: $data;
						  })) {
			return false;
		}

		return $data;
	}

	public function write($id, $data) {
		self :: $data = $data;
		$sessionKey   = '_session_' . $id;
		$memcache     = memcache::getInstance();
		$data         = $memcache->set($sessionKey, $data);

		return true;
	}

	public function destroy($id) {
		return memcached::delete("sessions/{$id}");
	}

	public function gc($maxlifetime) {
		return true;
	}

	public function close() {
		return true;
	}

	public function __destruct() {
		session_write_close();
	}
}
//$session = new Session();
//session_set_save_handler($session, true);
