/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.version;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.ui.popups.version.VersionInfoPanel;
import net.minecraft.launcher.ui.popups.version.VersionLaunchInfoPanel;
import net.minecraft.launcher.ui.popups.version.VersionLibrariesPanel;
import net.minecraft.launcher.ui.popups.version.VersionRequirementsPanel;
import net.minecraft.launcher.versions.CompleteVersion;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VersionEditorPopup
extends JPanel
implements ActionListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Launcher launcher;
    private final CompleteVersion originalVersion;
    private final CompleteVersion version;
    private final JButton saveButton = new JButton("Save Version");
    private final JButton cancelButton = new JButton("Cancel");
    private final JButton browseButton = new JButton("Open Version Dir");
    private final VersionInfoPanel versionInfoPanel;
    private final VersionLaunchInfoPanel versionLaunchInfoPanel;
    private final VersionRequirementsPanel versionRequirementsPanel;
    private final VersionLibrariesPanel versionLibrariesPanel;

    public VersionEditorPopup(Launcher launcher, CompleteVersion version) {
        super(true);
        this.launcher = launcher;
        this.originalVersion = version;
        this.version = new CompleteVersion(version);
        this.versionInfoPanel = new VersionInfoPanel(this);
        this.versionLaunchInfoPanel = new VersionLaunchInfoPanel(this);
        this.versionRequirementsPanel = new VersionRequirementsPanel(this);
        this.versionLibrariesPanel = new VersionLibrariesPanel(this);
        this.saveButton.setEnabled(false);
        this.browseButton.setEnabled(false);
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.browseButton.addActionListener(this);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(0, 5));
        this.createInterface();
    }

    protected void createInterface() {
        JPanel standardPanels = new JPanel(true);
        standardPanels.setLayout(new BoxLayout(standardPanels, 1));
        standardPanels.add(this.versionInfoPanel);
        standardPanels.add(this.versionLaunchInfoPanel);
        standardPanels.add(this.versionRequirementsPanel);
        standardPanels.add(this.versionLibrariesPanel);
        this.add((Component)standardPanels, "Center");
        JPanel buttonPannel = new JPanel();
        buttonPannel.setLayout(new BoxLayout(buttonPannel, 0));
        buttonPannel.add(this.cancelButton);
        buttonPannel.add(Box.createGlue());
        buttonPannel.add(this.browseButton);
        buttonPannel.add(Box.createHorizontalStrut(5));
        buttonPannel.add(this.saveButton);
        this.add((Component)buttonPannel, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.saveButton) {
            this.closeWindow();
        } else if (e.getSource() != this.browseButton) {
            this.closeWindow();
        }
    }

    private void closeWindow() {
        Window window = (Window)this.getTopLevelAncestor();
        window.dispatchEvent(new WindowEvent(window, 201));
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public CompleteVersion getVersion() {
        return this.version;
    }

    public static void showEditVersionDialog(Launcher launcher, CompleteVersion version) {
        JDialog dialog = new JDialog(launcher.getFrame(), "Version Editor", true);
        VersionEditorPopup editor = new VersionEditorPopup(launcher, version);
        dialog.add(editor);
        dialog.pack();
        dialog.setLocationRelativeTo(launcher.getFrame());
        dialog.setVisible(true);
    }
}

