/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity;

import java.util.ArrayList;
import java.util.List;

public class Vec3D {
    private static List vectorList = new ArrayList();
    private static int nextVector = 0;
    public double xCoord;
    public double yCoord;
    public double zCoord;

    public static Vec3D createVectorHelper(double par0, double par2, double par4) {
        return new Vec3D(par0, par2, par4);
    }

    public static void clearVectorList() {
        vectorList.clear();
        nextVector = 0;
    }

    public static void initialize() {
        nextVector = 0;
    }

    public static Vec3D createVector(double par0, double par2, double par4) {
        if (nextVector >= vectorList.size()) {
            vectorList.add(Vec3D.createVectorHelper(0.0, 0.0, 0.0));
        }
        return ((Vec3D)vectorList.get(nextVector++)).setComponents(par0, par2, par4);
    }

    private Vec3D(double par1, double par3, double par5) {
        if (par1 == -0.0) {
            par1 = 0.0;
        }
        if (par3 == -0.0) {
            par3 = 0.0;
        }
        if (par5 == -0.0) {
            par5 = 0.0;
        }
        this.xCoord = par1;
        this.yCoord = par3;
        this.zCoord = par5;
    }

    private Vec3D setComponents(double par1, double par3, double par5) {
        this.xCoord = par1;
        this.yCoord = par3;
        this.zCoord = par5;
        return this;
    }

    public Vec3D subtract(Vec3D par1Vec3D) {
        return Vec3D.createVector(par1Vec3D.xCoord - this.xCoord, par1Vec3D.yCoord - this.yCoord, par1Vec3D.zCoord - this.zCoord);
    }

    public Vec3D normalize() {
        double d2 = ou.a(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord);
        return d2 < 1.0E-4 ? Vec3D.createVector(0.0, 0.0, 0.0) : Vec3D.createVector(this.xCoord / d2, this.yCoord / d2, this.zCoord / d2);
    }

    public double dotProduct(Vec3D par1Vec3D) {
        return this.xCoord * par1Vec3D.xCoord + this.yCoord * par1Vec3D.yCoord + this.zCoord * par1Vec3D.zCoord;
    }

    public Vec3D crossProduct(Vec3D par1Vec3D) {
        return Vec3D.createVector(this.yCoord * par1Vec3D.zCoord - this.zCoord * par1Vec3D.yCoord, this.zCoord * par1Vec3D.xCoord - this.xCoord * par1Vec3D.zCoord, this.xCoord * par1Vec3D.yCoord - this.yCoord * par1Vec3D.xCoord);
    }

    public Vec3D addVector(double par1, double par3, double par5) {
        return Vec3D.createVector(this.xCoord + par1, this.yCoord + par3, this.zCoord + par5);
    }

    public double distanceTo(Vec3D par1Vec3D) {
        double d2 = par1Vec3D.xCoord - this.xCoord;
        double d1 = par1Vec3D.yCoord - this.yCoord;
        double d22 = par1Vec3D.zCoord - this.zCoord;
        return ou.a(d2 * d2 + d1 * d1 + d22 * d22);
    }

    public double squareDistanceTo(Vec3D par1Vec3D) {
        double d2 = par1Vec3D.xCoord - this.xCoord;
        double d1 = par1Vec3D.yCoord - this.yCoord;
        double d22 = par1Vec3D.zCoord - this.zCoord;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public double squareDistanceTo(double par1, double par3, double par5) {
        double d2 = par1 - this.xCoord;
        double d1 = par3 - this.yCoord;
        double d22 = par5 - this.zCoord;
        return d2 * d2 + d1 * d1 + d22 * d22;
    }

    public double lengthVector() {
        return ou.a(this.xCoord * this.xCoord + this.yCoord * this.yCoord + this.zCoord * this.zCoord);
    }

    public Vec3D getIntermediateWithXValue(Vec3D par1Vec3D, double par2) {
        double d2 = par1Vec3D.xCoord - this.xCoord;
        double d1 = par1Vec3D.yCoord - this.yCoord;
        double d22 = par1Vec3D.zCoord - this.zCoord;
        if (d2 * d2 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (par2 - this.xCoord) / d2;
        return d3 >= 0.0 && d3 <= 1.0 ? Vec3D.createVector(this.xCoord + d2 * d3, this.yCoord + d1 * d3, this.zCoord + d22 * d3) : null;
    }

    public Vec3D getIntermediateWithYValue(Vec3D par1Vec3D, double par2) {
        double d2 = par1Vec3D.xCoord - this.xCoord;
        double d1 = par1Vec3D.yCoord - this.yCoord;
        double d22 = par1Vec3D.zCoord - this.zCoord;
        if (d1 * d1 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (par2 - this.yCoord) / d1;
        return d3 >= 0.0 && d3 <= 1.0 ? Vec3D.createVector(this.xCoord + d2 * d3, this.yCoord + d1 * d3, this.zCoord + d22 * d3) : null;
    }

    public Vec3D getIntermediateWithZValue(Vec3D par1Vec3D, double par2) {
        double d2 = par1Vec3D.xCoord - this.xCoord;
        double d1 = par1Vec3D.yCoord - this.yCoord;
        double d22 = par1Vec3D.zCoord - this.zCoord;
        if (d22 * d22 < (double)1.0E-7f) {
            return null;
        }
        double d3 = (par2 - this.zCoord) / d22;
        return d3 >= 0.0 && d3 <= 1.0 ? Vec3D.createVector(this.xCoord + d2 * d3, this.yCoord + d1 * d3, this.zCoord + d22 * d3) : null;
    }

    public String toString() {
        return "(" + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + ")";
    }

    public void rotateAroundX(float par1) {
        float f2 = ou.b(par1);
        float f1 = ou.a(par1);
        double d2 = this.xCoord;
        double d1 = this.yCoord * (double)f2 + this.zCoord * (double)f1;
        double d22 = this.zCoord * (double)f2 - this.yCoord * (double)f1;
        this.xCoord = d2;
        this.yCoord = d1;
        this.zCoord = d22;
    }

    public void rotateAroundY(float par1) {
        float f2 = ou.b(par1);
        float f1 = ou.a(par1);
        double d2 = this.xCoord * (double)f2 + this.zCoord * (double)f1;
        double d1 = this.yCoord;
        double d22 = this.zCoord * (double)f2 - this.xCoord * (double)f1;
        this.xCoord = d2;
        this.yCoord = d1;
        this.zCoord = d22;
    }
}

