/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import fr.toss.grillecube.groupe.GroupeServer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements ac,
Runnable,
px {
    public List<GroupeServer> groupes = new ArrayList<GroupeServer>();
    public static final Logger h = LogManager.getLogger();
    public static MinecraftServer i;
    public final axq j;
    public final pv k = new pv("server", this, MinecraftServer.ap());
    public final File l;
    public final List m = new ArrayList();
    public final ab n;
    public final ov a = new ov();
    public final ms o;
    public final jp p = new jp();
    public final Random q = new Random();
    public int s = -1;
    public mj[] b;
    public ld t;
    public boolean u = true;
    public boolean v;
    public int w;
    public final Proxy c;
    public String d;
    public int e;
    public boolean x;
    public boolean y;
    public boolean z;
    public boolean A;
    public boolean B;
    public String C;
    public int D;
    public int E = 0;
    public final long[] f = new long[100];
    public long[][] g;
    public KeyPair F;
    public String G;
    public String H;
    public String I;
    public boolean J;
    public boolean K;
    public boolean L;
    public String M = "";
    public boolean N;
    public long O;
    public String P;
    public boolean Q;
    public boolean R;
    public final MinecraftSessionService S;
    public long T = 0L;
    public static final String __OBFID = "CL_00001462";

    public MinecraftServer(File p_i45281_1_, Proxy p_i45281_2_) {
        i = this;
        this.c = p_i45281_2_;
        this.l = p_i45281_1_;
        this.o = new ms(this);
        this.n = new bk();
        this.j = new awz(p_i45281_1_);
        this.S = new YggdrasilAuthenticationService(p_i45281_2_, UUID.randomUUID().toString()).createMinecraftSessionService();
    }

    public abstract boolean e() throws IOException;

    public void a(String par1Str) {
        if (this.Q().b(par1Str)) {
            h.info("Converting map!");
            this.b("menu.convertingLevel");
            this.Q().a(par1Str, new kw(this));
        }
    }

    public synchronized void b(String par1Str) {
        this.P = par1Str;
    }

    public synchronized String f() {
        return this.P;
    }

    public void a(String par1Str, String par2Str, long par3, afy par5WorldType, String par6Str) {
        afv var8;
        this.a(par1Str);
        this.b("menu.loadingLevel");
        this.b = new mj[4];
        this.g = new long[this.b.length][100];
        axo var7 = this.j.a(par1Str, true);
        axe var9 = var7.d();
        if (var9 == null) {
            var8 = new afv(par3, this.i(), this.h(), this.k(), par5WorldType);
            var8.a(par6Str);
        } else {
            var8 = new afv(var9);
        }
        if (this.K) {
            var8.a();
        }
        for (int var10 = 0; var10 < this.b.length; ++var10) {
            int var11 = 0;
            if (var10 == 1) {
                var11 = -1;
            }
            if (var10 == 2) {
                var11 = 1;
            }
            this.b[var10] = var10 == 0 ? (this.P() ? new ma(this, var7, par2Str, var11, this.a) : new mj(this, var7, par2Str, var11, var8, this.a)) : new mc(this, var7, par2Str, var11, var8, this.b[0], this.a);
            this.b[var10].a(new mf(this, this.b[var10]));
            if (!this.L()) {
                this.b[var10].M().a(this.i());
            }
            this.t.a(this.b);
        }
        this.a(this.j());
        this.g();
    }

    public void g() {
        boolean var1 = true;
        boolean var2 = true;
        boolean var3 = true;
        boolean var4 = true;
        int var5 = 0;
        this.b("menu.generatingTerrain");
        int var6 = 0;
        h.info("Preparing start region for level " + var6);
        mj var7 = this.b[var6];
        r var8 = var7.J();
        long var9 = MinecraftServer.ap();
        for (int var11 = -192; var11 <= 192 && this.p(); var11 += 16) {
            for (int var12 = -192; var12 <= 192 && this.p(); var12 += 16) {
                long var13 = MinecraftServer.ap();
                if (var13 - var9 > 1000L) {
                    this.a_("Preparing spawn area", var5 * 100 / 625);
                    var9 = var13;
                }
                ++var5;
                var7.b.c(var8.a + var11 >> 4, var8.c + var12 >> 4);
            }
        }
        this.m();
    }

    public abstract boolean h();

    public abstract afw i();

    public abstract pq j();

    public abstract boolean k();

    public abstract int l();

    public void a_(String par1Str, int par2) {
        this.d = par1Str;
        this.e = par2;
        h.info(par1Str + ": " + par2 + "%");
    }

    public void m() {
        this.d = null;
        this.e = 0;
    }

    public void a(boolean par1) {
        if (!this.L) {
            for (mj world : this.b) {
                if (world == null) continue;
                if (!par1) {
                    h.info("Saving chunks for level '" + world.M().k() + "'/" + world.t.l() + " - " + world.t.i);
                }
                try {
                    world.a(true, (ox)null);
                }
                catch (afs var7) {
                    h.warn(var7.getMessage());
                }
            }
        }
    }

    public void n() {
        if (!this.L) {
            h.info("Stopping server");
            if (this.ag() != null) {
                this.ag().b();
            }
            if (this.t != null) {
                h.info("Saving players");
                this.t.g();
                this.t.r();
            }
            h.info("Saving worlds");
            this.a(false);
            for (int var1 = 0; var1 < this.b.length; ++var1) {
                mj var2 = this.b[var1];
                var2.n();
            }
            if (this.k.d()) {
                this.k.e();
            }
        }
    }

    public boolean p() {
        return this.u;
    }

    public void q() {
        this.u = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.e()) {
                long var1 = MinecraftServer.ap();
                long var50 = 0L;
                this.p.a(new fh(this.C));
                this.p.a(new jt("1.7.2", 4));
                this.a(this.p);
                while (this.u) {
                    long var5 = MinecraftServer.ap();
                    long var7 = var5 - var1;
                    if (var7 > 2000L && var1 - this.O >= 15000L) {
                        h.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{var7, var7 / 50L});
                        var7 = 2000L;
                        this.O = var1;
                    }
                    if (var7 < 0L) {
                        h.warn("Time ran backwards! Did the system time change?");
                        var7 = 0L;
                    }
                    var50 += var7;
                    var1 = var5;
                    if (this.b[0].e()) {
                        this.t();
                        var50 = 0L;
                    } else {
                        while (var50 > 50L) {
                            var50 -= 50L;
                            this.t();
                        }
                    }
                    Thread.sleep(1L);
                    this.N = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable var48) {
            h.error("Encountered an unexpected exception", var48);
            b var2 = null;
            var2 = var48 instanceof s ? this.b(((s)var48).a()) : this.b(new b("Exception in server tick loop", var48));
            File var3 = new File(new File(this.r(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (var2.a(var3)) {
                h.error("This crash report has been saved to: " + var3.getAbsolutePath());
            } else {
                h.error("We were unable to save this crash report to disk.");
            }
            this.a(var2);
        }
        finally {
            try {
                this.n();
                this.v = true;
            }
            catch (Throwable var46) {
                h.error("Exception stopping the server", var46);
            }
            finally {
                this.s();
            }
        }
    }

    public void a(jp p_147138_1_) {
        File var2 = this.d("server-icon.png");
        if (var2.isFile()) {
            ByteBuf var3 = Unpooled.buffer();
            try {
                BufferedImage var4 = ImageIO.read(var2);
                Validate.validState((var4.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((var4.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)var4, "PNG", (OutputStream)new ByteBufOutputStream(var3));
                ByteBuf var5 = Base64.encode((ByteBuf)var3);
                p_147138_1_.a("data:image/png;base64," + var5.toString(Charsets.UTF_8));
            }
            catch (Exception var6) {
                h.error("Couldn't load server icon", (Throwable)var6);
            }
        }
    }

    public File r() {
        return new File(".");
    }

    public void a(b par1CrashReport) {
    }

    public void s() {
    }

    public void t() {
        long var1 = System.nanoTime();
        ayf.a().a();
        ++this.w;
        if (this.Q) {
            this.Q = false;
            this.a.a = true;
            this.a.a();
        }
        this.a.a("root");
        this.u();
        if (var1 - this.T >= 5000000000L) {
            this.T = var1;
            this.p.a(new jq(this.C(), this.B()));
            GameProfile[] var3 = new GameProfile[Math.min(this.B(), 12)];
            int var4 = ou.a(this.q, 0, this.B() - var3.length);
            for (int var5 = 0; var5 < var3.length; ++var5) {
                var3[var5] = ((mm)this.t.a.get(var4 + var5)).bH();
            }
            Collections.shuffle(Arrays.asList(var3));
            this.p.b().a(var3);
        }
        if (this.w % 900 == 0) {
            this.a.a("save");
            this.t.g();
            this.a(true);
            this.a.b();
        }
        this.a.a("tallying");
        this.f[this.w % 100] = System.nanoTime() - var1;
        this.a.b();
        this.a.a("snooper");
        if (!this.k.d() && this.w > 100) {
            this.k.a();
        }
        if (this.w % 6000 == 0) {
            this.k.b();
        }
        this.a.b();
        this.a.b();
    }

    public void u() {
        int var1;
        this.a.a("levels");
        for (var1 = 0; var1 < this.b.length; ++var1) {
            long var2 = System.nanoTime();
            if (var1 == 0 || this.v()) {
                mj var4 = this.b[var1];
                this.a.a(var4.M().k());
                this.a.a("pools");
                var4.U().a();
                this.a.b();
                if (this.w % 20 == 0) {
                    this.a.a("timeSync");
                    this.t.a(new hu(var4.H(), var4.I(), var4.N().b("doDaylightCycle")), var4.t.i);
                    this.a.b();
                }
                this.a.a("tick");
                try {
                    var4.b();
                }
                catch (Throwable var8) {
                    b var6 = b.a(var8, "Exception ticking world");
                    var4.a(var6);
                    throw new s(var6);
                }
                try {
                    var4.h();
                }
                catch (Throwable var7) {
                    b var6 = b.a(var7, "Exception ticking world entities");
                    var4.a(var6);
                    throw new s(var6);
                }
                this.a.b();
                this.a.a("tracker");
                var4.q().a();
                this.a.b();
                this.a.b();
            }
            this.g[var1][this.w % 100] = System.nanoTime() - var2;
        }
        this.a.c("connection");
        this.ag().c();
        this.a.c("players");
        this.t.b();
        this.a.c("tickables");
        for (var1 = 0; var1 < this.m.size(); ++var1) {
            ((lh)this.m.get(var1)).a();
        }
        this.a.b();
    }

    public boolean v() {
        return true;
    }

    public void w() {
        new ky(this, "Server thread").start();
    }

    public File d(String par1Str) {
        return new File(this.r(), par1Str);
    }

    public void f(String par1Str) {
        h.warn(par1Str);
    }

    public mj a(int par1) {
        return par1 == -1 ? this.b[1] : (par1 == 1 ? this.b[2] : (par1 == 2 ? this.b[3] : this.b[0]));
    }

    public String A() {
        return "1.7.2";
    }

    public int B() {
        return this.t.k();
    }

    public int C() {
        return this.t.l();
    }

    public String[] D() {
        return this.t.d();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b par1CrashReport) {
        par1CrashReport.g().a("Profiler Position", new kz(this));
        if (this.b != null && this.b.length > 0 && this.b[0] != null) {
            par1CrashReport.g().a("Vec3 Pool Size", new la(this));
        }
        if (this.t != null) {
            par1CrashReport.g().a("Player Count", new lb(this));
        }
        return par1CrashReport;
    }

    public List a(ac par1ICommandSender, String par2Str) {
        ArrayList<String> var3 = new ArrayList<String>();
        if (par2Str.startsWith("/")) {
            boolean var10 = !(par2Str = par2Str.substring(1)).contains(" ");
            List var11 = this.n.b(par1ICommandSender, par2Str);
            if (var11 != null) {
                for (String var13 : var11) {
                    if (var10) {
                        var3.add("/" + var13);
                        continue;
                    }
                    var3.add(var13);
                }
            }
            return var3;
        }
        String[] var4 = par2Str.split(" ", -1);
        String var5 = var4[var4.length - 1];
        for (String var9 : this.t.d()) {
            if (!y.a(var5, var9)) continue;
            var3.add(var9);
        }
        return var3;
    }

    public static MinecraftServer G() {
        return i;
    }

    @Override
    public String b_() {
        return "Server";
    }

    @Override
    public void a(fa p_145747_1_) {
        h.info(p_145747_1_.c());
    }

    @Override
    public boolean a(int par1, String par2Str) {
        return true;
    }

    public ab H() {
        return this.n;
    }

    public KeyPair I() {
        return this.F;
    }

    public String K() {
        return this.G;
    }

    public void j(String par1Str) {
        this.G = par1Str;
    }

    public boolean L() {
        return this.G != null;
    }

    public String M() {
        return this.H;
    }

    public void k(String par1Str) {
        this.H = par1Str;
    }

    public void l(String par1Str) {
        this.I = par1Str;
    }

    public String N() {
        return this.I;
    }

    public void a(KeyPair par1KeyPair) {
        this.F = par1KeyPair;
    }

    public void a(pq p_147139_1_) {
        for (int var2 = 0; var2 < this.b.length; ++var2) {
            mj var3 = this.b[var2];
            if (var3 == null) continue;
            if (var3.M().t()) {
                var3.r = pq.d;
                var3.a(true, true);
                continue;
            }
            if (this.L()) {
                var3.r = p_147139_1_;
                var3.a(var3.r != pq.a, true);
                continue;
            }
            var3.r = p_147139_1_;
            var3.a(this.O(), this.y);
        }
    }

    public boolean O() {
        return true;
    }

    public boolean P() {
        return this.J;
    }

    public void b(boolean par1) {
        this.J = par1;
    }

    public void c(boolean par1) {
        this.K = par1;
    }

    public axq Q() {
        return this.j;
    }

    public void S() {
        this.L = true;
        this.Q().d();
        for (int var1 = 0; var1 < this.b.length; ++var1) {
            mj var2 = this.b[var1];
            if (var2 == null) continue;
            var2.n();
        }
        this.Q().e(this.b[0].L().g());
        this.q();
    }

    public String T() {
        return this.M;
    }

    @Override
    public void a(pv par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.a("whitelist_enabled", false);
        par1PlayerUsageSnooper.a("whitelist_count", 0);
        par1PlayerUsageSnooper.a("players_current", this.B());
        par1PlayerUsageSnooper.a("players_max", this.C());
        par1PlayerUsageSnooper.a("players_seen", this.t.m().length);
        par1PlayerUsageSnooper.a("uses_auth", this.x);
        par1PlayerUsageSnooper.a("gui_state", this.ai() ? "enabled" : "disabled");
        par1PlayerUsageSnooper.a("run_time", (MinecraftServer.ap() - par1PlayerUsageSnooper.g()) / 60L * 1000L);
        par1PlayerUsageSnooper.a("avg_tick_ms", (int)(ou.a(this.f) * 1.0E-6));
        int var2 = 0;
        for (int var3 = 0; var3 < this.b.length; ++var3) {
            if (this.b[var3] == null) continue;
            mj var4 = this.b[var3];
            axe var5 = var4.M();
            par1PlayerUsageSnooper.a("world[" + var2 + "][dimension]", var4.t.i);
            par1PlayerUsageSnooper.a("world[" + var2 + "][mode]", (Object)var5.r());
            par1PlayerUsageSnooper.a("world[" + var2 + "][difficulty]", (Object)var4.r);
            par1PlayerUsageSnooper.a("world[" + var2 + "][hardcore]", var5.t());
            par1PlayerUsageSnooper.a("world[" + var2 + "][generator_name]", var5.u().a());
            par1PlayerUsageSnooper.a("world[" + var2 + "][generator_version]", var5.u().d());
            par1PlayerUsageSnooper.a("world[" + var2 + "][height]", this.D);
            par1PlayerUsageSnooper.a("world[" + var2 + "][chunks_loaded]", var4.K().f());
            ++var2;
        }
        par1PlayerUsageSnooper.a("worlds", var2);
    }

    @Override
    public void b(pv par1PlayerUsageSnooper) {
        par1PlayerUsageSnooper.a("singleplayer", this.L());
        par1PlayerUsageSnooper.a("server_brand", this.getServerModName());
        par1PlayerUsageSnooper.a("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        par1PlayerUsageSnooper.a("dedicated", this.V());
    }

    @Override
    public boolean U() {
        return true;
    }

    public abstract boolean V();

    public boolean W() {
        return this.x;
    }

    public void d(boolean par1) {
        this.x = par1;
    }

    public boolean X() {
        return this.y;
    }

    public void e(boolean par1) {
        this.y = par1;
    }

    public boolean Y() {
        return this.z;
    }

    public void f(boolean par1) {
        this.z = par1;
    }

    public boolean Z() {
        return this.A;
    }

    public void g(boolean par1) {
        this.A = par1;
    }

    public boolean aa() {
        return this.B;
    }

    public void h(boolean par1) {
        this.B = par1;
    }

    public abstract boolean ab();

    public String ac() {
        return this.C;
    }

    public void n(String par1Str) {
        this.C = par1Str;
    }

    public int ad() {
        return this.D;
    }

    public void c(int par1) {
        this.D = par1;
    }

    public ld af() {
        return this.t;
    }

    public void a(ld par1ServerConfigurationManager) {
        this.t = par1ServerConfigurationManager;
    }

    public void a(afw par1EnumGameType) {
        for (int var2 = 0; var2 < this.b.length; ++var2) {
            MinecraftServer.G().b[var2].M().a(par1EnumGameType);
        }
    }

    public ms ag() {
        return this.o;
    }

    public boolean ah() {
        return this.N;
    }

    public boolean ai() {
        return false;
    }

    public abstract String a(afw var1, boolean var2);

    public int aj() {
        return this.w;
    }

    public void ak() {
        this.Q = true;
    }

    public pv al() {
        return this.k;
    }

    @Override
    public r f_() {
        return new r(0, 0, 0);
    }

    @Override
    public afn d() {
        return this.b[0];
    }

    public int am() {
        return 16;
    }

    public boolean a(afn par1World, int par2, int par3, int par4, xl par5EntityPlayer) {
        return false;
    }

    public boolean an() {
        return this.R;
    }

    public Proxy ao() {
        return this.c;
    }

    public static long ap() {
        return System.currentTimeMillis();
    }

    public int aq() {
        return this.E;
    }

    public void d(int par1) {
        this.E = par1;
    }

    @Override
    public fa c_() {
        return new fh(this.b_());
    }

    public boolean ar() {
        return true;
    }

    public MinecraftSessionService as() {
        return this.S;
    }

    public jp at() {
        return this.p;
    }

    public void au() {
        this.T = 0L;
    }

    public GroupeServer getGroupeByName(String pname) {
        for (GroupeServer gr2 : this.groupes) {
            if (!gr2.name.equals(pname)) continue;
            return gr2;
        }
        return null;
    }

    public void removeGroup(String name) {
        for (int i2 = 0; i2 < this.groupes.size(); ++i2) {
            if (!this.groupes.get((int)i2).name.equals(name)) continue;
            this.groupes.remove(i2);
        }
    }
}

