/*
 * Decompiled with CFR 0.152.
 */
package org.darkstorm.minecraft.gui.theme;

import java.util.HashMap;
import java.util.Map;
import org.darkstorm.minecraft.gui.component.Component;
import org.darkstorm.minecraft.gui.theme.AbstractComponentUI;
import org.darkstorm.minecraft.gui.theme.ComponentUI;
import org.darkstorm.minecraft.gui.theme.Theme;

public abstract class AbstractTheme
implements Theme {
    protected final Map<Class<? extends Component>, ComponentUI> uis = new HashMap<Class<? extends Component>, ComponentUI>();

    protected void installUI(AbstractComponentUI<?> ui2) {
        this.uis.put(ui2.handledComponentClass, ui2);
    }

    @Override
    public ComponentUI getUIForComponent(Component component) {
        if (component == null || !(component instanceof Component)) {
            throw new IllegalArgumentException();
        }
        return this.getComponentUIForClass(component.getClass());
    }

    public ComponentUI getComponentUIForClass(Class<? extends Component> componentClass) {
        for (Class<?> componentInterface : componentClass.getInterfaces()) {
            ComponentUI ui2 = this.uis.get(componentInterface);
            if (ui2 == null) continue;
            return ui2;
        }
        if (componentClass.getSuperclass().equals(Component.class)) {
            return this.uis.get(componentClass);
        }
        if (!Component.class.isAssignableFrom(componentClass.getSuperclass())) {
            return null;
        }
        return this.getComponentUIForClass(componentClass.getSuperclass());
    }
}

