/*
 * Decompiled with CFR 0.152.
 */
package org.darkstorm.minecraft.gui.theme.wurst;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.darkstorm.minecraft.gui.component.Button;
import org.darkstorm.minecraft.gui.component.Container;
import org.darkstorm.minecraft.gui.component.Frame;
import org.darkstorm.minecraft.gui.theme.AbstractComponentUI;
import org.darkstorm.minecraft.gui.theme.wurst.WurstTheme;
import org.darkstorm.minecraft.gui.util.GuiManagerDisplayScreen;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import wurst.Client;
import wurst.module.Category;
import wurst.module.Module;

public class WurstButtonUI
extends AbstractComponentUI<Button> {
    private final WurstTheme theme;
    private long lastMS;
    private Button describedButton;
    private long currentMS;

    WurstButtonUI(WurstTheme theme) {
        super(Button.class);
        this.theme = theme;
        this.foreground = Color.WHITE;
        this.background = new Color(0, 0, 0, 0);
    }

    @Override
    protected void renderComponent(Button button) {
        this.translateComponent(button, false);
        Rectangle area = button.getArea();
        area.width = button.getParent().getWidth() - 4;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3553);
        RenderUtil.setColor(button.getBackgroundColor());
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)area.height);
        GL11.glVertex2d((double)0.0, (double)area.height);
        GL11.glEnd();
        RenderUtil.setColor(new Color(0, 0, 0, 255));
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)area.height);
        GL11.glVertex2d((double)0.0, (double)area.height);
        GL11.glEnd();
        Point mouse = RenderUtil.calculateMouseLocation();
        Point rawMouse = RenderUtil.calculateMouseLocation();
        int fontHeight = this.theme.getFontRenderer().a;
        for (Container parent = button.getParent(); parent != null; parent = parent.getParent()) {
            mouse.x -= parent.getX();
            mouse.y -= parent.getY();
        }
        if (area.contains(mouse) && azd.A().n instanceof GuiManagerDisplayScreen) {
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)(Mouse.isButtonDown((int)0) ? 0.3f : 0.2f));
            GL11.glBegin((int)7);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)area.width, (double)0.0);
            GL11.glVertex2d((double)area.width, (double)area.height);
            GL11.glVertex2d((double)0.0, (double)area.height);
            GL11.glEnd();
        }
        String text = button.getText();
        this.theme.getFontRenderer().b(text, area.width / 2 - this.theme.getFontRenderer().a(text) / 2, area.height / 2 - this.theme.getFontRenderer().a / 2, RenderUtil.toRGBA(button.getForegroundColor()));
        this.translateComponent(button, true);
        if (area.contains(mouse) && this.describedButton != button) {
            this.lastMS = 0L;
            this.describedButton = button;
        }
        if (this.describedButton != null && this.isRightButton(button, this.describedButton) && azd.A().n instanceof GuiManagerDisplayScreen) {
            int scaleFactor;
            int fontWidth = this.theme.getFontRenderer().a(this.describedButton.getDescription());
            Rectangle dArea = this.describedButton.getArea();
            dArea.width = this.describedButton.getParent().getWidth() - 4;
            if (this.lastMS == 0L) {
                this.lastMS = System.currentTimeMillis();
                return;
            }
            if (System.currentTimeMillis() < this.lastMS + 500L) {
                return;
            }
            for (Module module : Client.Wurst.moduleManager.activeModules) {
                if (!button.getText().equals(module.getName())) continue;
                for (Frame frame : Client.Wurst.guiManager.getFrames()) {
                    if (!frame.getTitle().equalsIgnoreCase(module.getCategory().name())) continue;
                    Client.Wurst.guiManager.bringForward(frame);
                }
            }
            int scale = azd.A().u.at;
            if (scale == 0) {
                scale = 1000;
            }
            for (scaleFactor = 0; scaleFactor < scale && azd.A().d / (scaleFactor + 1) >= 320 && azd.A().e / (scaleFactor + 1) >= 240; ++scaleFactor) {
            }
            if (rawMouse.x + 8 + fontWidth > azd.A().d / scaleFactor) {
                rawMouse.x -= fontWidth + 16;
            }
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3553);
            RenderUtil.setColor(new Color(64, 64, 64, 192));
            GL11.glBegin((int)7);
            GL11.glVertex2d((double)(rawMouse.x + 6), (double)(rawMouse.y - 5));
            GL11.glVertex2d((double)(rawMouse.x + fontWidth + 11), (double)(rawMouse.y - 5));
            GL11.glVertex2d((double)(rawMouse.x + fontWidth + 11), (double)(rawMouse.y + 7));
            GL11.glVertex2d((double)(rawMouse.x + 6), (double)(rawMouse.y + 7));
            GL11.glEnd();
            GL11.glLineWidth((float)1.0f);
            RenderUtil.setColor(new Color(0, 0, 0, 255));
            GL11.glBegin((int)2);
            GL11.glVertex2d((double)(rawMouse.x + 6), (double)(rawMouse.y - 5));
            GL11.glVertex2d((double)(rawMouse.x + fontWidth + 11), (double)(rawMouse.y - 5));
            GL11.glVertex2d((double)(rawMouse.x + fontWidth + 11), (double)(rawMouse.y + 7));
            GL11.glVertex2d((double)(rawMouse.x + 6), (double)(rawMouse.y + 7));
            GL11.glEnd();
            this.theme.getFontRenderer().b(this.describedButton.getDescription(), rawMouse.x + 8, rawMouse.y - 5, RenderUtil.toRGBA(Color.WHITE));
            GL11.glEnable((int)2884);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
        if (!area.contains(mouse) && this.describedButton == button) {
            this.lastMS = 0L;
            this.describedButton = null;
        }
    }

    private boolean isRightButton(Button button, Button dButton) {
        Category buttonCategory = null;
        Category dButtonCategory = null;
        for (Module module : Client.Wurst.moduleManager.activeModules) {
            if (button.getText().equals(module.getName())) {
                buttonCategory = module.getCategory();
            }
            if (!dButton.getText().equals(module.getName())) continue;
            dButtonCategory = module.getCategory();
        }
        boolean isRightFrame = buttonCategory == dButtonCategory && buttonCategory != null;
        boolean isLastButton = false;
        for (Module module : Client.Wurst.moduleManager.activeModules) {
            if (buttonCategory != module.getCategory()) continue;
            if (button.getText().equals(module.getName())) {
                isLastButton = true;
                continue;
            }
            isLastButton = false;
        }
        return isRightFrame && isLastButton;
    }

    @Override
    protected Dimension getDefaultComponentSize(Button component) {
        return new Dimension(this.theme.getFontRenderer().a(component.getText()) + 4, this.theme.getFontRenderer().a + 4);
    }

    @Override
    protected Rectangle[] getInteractableComponentRegions(Button component) {
        return new Rectangle[]{new Rectangle(0, 0, component.getWidth(), component.getHeight())};
    }

    @Override
    protected void handleComponentInteraction(Button component, Point location, int button) {
        if (location.x <= component.getWidth() && location.y <= component.getHeight() && button == 0) {
            component.press();
        }
    }
}

