/*
 * Decompiled with CFR 0.152.
 */
package org.darkstorm.minecraft.gui.theme.wurst;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import org.darkstorm.minecraft.gui.component.ComboBox;
import org.darkstorm.minecraft.gui.component.Container;
import org.darkstorm.minecraft.gui.theme.AbstractComponentUI;
import org.darkstorm.minecraft.gui.theme.wurst.WurstTheme;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class WurstComboBoxUI
extends AbstractComponentUI<ComboBox> {
    private final WurstTheme theme;

    WurstComboBoxUI(WurstTheme theme) {
        super(ComboBox.class);
        this.theme = theme;
        this.foreground = Color.WHITE;
        this.background = new Color(64, 64, 64, 128);
    }

    @Override
    protected void renderComponent(ComboBox component) {
        int height;
        int i2;
        String[] elements;
        this.translateComponent(component, false);
        Rectangle area = component.getArea();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3553);
        int maxWidth = 0;
        for (String element : component.getElements()) {
            maxWidth = Math.max(maxWidth, this.theme.getFontRenderer().a(element));
        }
        int extendedHeight = 0;
        if (component.isSelected()) {
            String[] elements2 = component.getElements();
            for (int i3 = 0; i3 < elements2.length - 1; ++i3) {
                extendedHeight += this.theme.getFontRenderer().a + 2;
            }
            extendedHeight += 2;
        }
        GL11.glLineWidth((float)1.5f);
        RenderUtil.setColor(Color.BLACK);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)area.height);
        GL11.glVertex2d((double)0.0, (double)area.height);
        GL11.glEnd();
        RenderUtil.setColor(component.getBackgroundColor());
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)0.0, (double)area.height);
        GL11.glVertex2d((double)area.width, (double)area.height);
        GL11.glVertex2d((double)area.width, (double)(area.height + extendedHeight));
        GL11.glVertex2d((double)0.0, (double)(area.height + extendedHeight));
        GL11.glEnd();
        Point mouse = RenderUtil.calculateMouseLocation();
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            mouse.x -= parent.getX();
            mouse.y -= parent.getY();
        }
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)(Mouse.isButtonDown((int)0) ? 0.5f : 0.3f));
        if (area.contains(mouse)) {
            GL11.glBegin((int)7);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)area.width, (double)0.0);
            GL11.glVertex2d((double)area.width, (double)area.height);
            GL11.glVertex2d((double)0.0, (double)area.height);
            GL11.glEnd();
            int height2 = this.theme.getFontRenderer().a + 4;
            GL11.glBegin((int)4);
            if (component.isSelected()) {
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)(Mouse.isButtonDown((int)0) ? 0.5f : 0.3f));
                GL11.glVertex2d((double)((double)(maxWidth + 4) + (double)height2 / 2.0), (double)((double)height2 / 3.0));
                GL11.glVertex2d((double)((double)maxWidth + 2.5 + (double)height2 / 3.0), (double)(2.0 * (double)height2 / 3.0));
                GL11.glVertex2d((double)((double)maxWidth + 5.5 + 2.0 * (double)height2 / 3.0), (double)(2.0 * (double)height2 / 3.0));
            } else {
                GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)(Mouse.isButtonDown((int)0) ? 0.5f : 0.3f));
                GL11.glVertex2d((double)((double)maxWidth + 2.5 + (double)height2 / 3.0), (double)((double)height2 / 3.0));
                GL11.glVertex2d((double)((double)maxWidth + 5.5 + 2.0 * (double)height2 / 3.0), (double)((double)height2 / 3.0));
                GL11.glVertex2d((double)((double)(maxWidth + 4) + (double)height2 / 2.0), (double)(2.0 * (double)height2 / 3.0));
            }
            GL11.glEnd();
        } else if (component.isSelected() && mouse.x >= area.x && mouse.x <= area.x + area.width) {
            int offset = component.getHeight();
            elements = component.getElements();
            for (i2 = 0; i2 < elements.length; ++i2) {
                if (i2 == component.getSelectedIndex()) continue;
                height = this.theme.getFontRenderer().a + 2;
                if ((component.getSelectedIndex() != 0 ? i2 == 0 : i2 == 1) || (component.getSelectedIndex() == elements.length - 1 ? i2 == elements.length - 2 : i2 == elements.length - 1)) {
                    ++height;
                }
                if (mouse.y >= area.y + offset && mouse.y <= area.y + offset + height) {
                    GL11.glBegin((int)7);
                    GL11.glVertex2d((double)0.0, (double)offset);
                    GL11.glVertex2d((double)0.0, (double)(offset + height));
                    GL11.glVertex2d((double)area.width, (double)(offset + height));
                    GL11.glVertex2d((double)area.width, (double)offset);
                    GL11.glEnd();
                    break;
                }
                offset += height;
            }
        }
        if (component.isSelected()) {
            RenderUtil.setColor(Color.BLACK);
            int offset2 = component.getHeight();
            elements = component.getElements();
            for (i2 = 0; i2 < elements.length; ++i2) {
                if (i2 == component.getSelectedIndex()) continue;
                height = this.theme.getFontRenderer().a + 2;
                if ((component.getSelectedIndex() != 0 ? i2 == 0 : i2 == 1) || (component.getSelectedIndex() == elements.length - 1 ? i2 == elements.length - 2 : i2 == elements.length - 1)) {
                    ++height;
                }
                GL11.glBegin((int)2);
                GL11.glVertex2d((double)0.0, (double)offset2);
                GL11.glVertex2d((double)0.0, (double)(offset2 + height));
                GL11.glVertex2d((double)area.width, (double)(offset2 + height));
                GL11.glVertex2d((double)area.width, (double)offset2);
                GL11.glEnd();
                offset2 += height;
            }
        }
        int height3 = this.theme.getFontRenderer().a + 4;
        GL11.glBegin((int)4);
        if (component.isSelected()) {
            GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.3f);
            GL11.glVertex2d((double)((double)(maxWidth + 4) + (double)height3 / 2.0), (double)((double)height3 / 3.0));
            GL11.glVertex2d((double)((double)maxWidth + 2.5 + (double)height3 / 3.0), (double)(2.0 * (double)height3 / 3.0));
            GL11.glVertex2d((double)((double)maxWidth + 5.5 + 2.0 * (double)height3 / 3.0), (double)(2.0 * (double)height3 / 3.0));
        } else {
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)0.3f);
            GL11.glVertex2d((double)((double)maxWidth + 2.5 + (double)height3 / 3.0), (double)((double)height3 / 3.0));
            GL11.glVertex2d((double)((double)maxWidth + 5.5 + 2.0 * (double)height3 / 3.0), (double)((double)height3 / 3.0));
            GL11.glVertex2d((double)((double)(maxWidth + 4) + (double)height3 / 2.0), (double)(2.0 * (double)height3 / 3.0));
        }
        GL11.glEnd();
        GL11.glLineWidth((float)1.0f);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)1);
        GL11.glVertex2d((double)(maxWidth + 4), (double)2.0);
        GL11.glVertex2d((double)(maxWidth + 4), (double)(area.height - 2));
        GL11.glEnd();
        GL11.glLineWidth((float)1.0f);
        GL11.glBegin((int)2);
        if (component.isSelected()) {
            GL11.glVertex2d((double)((double)(maxWidth + 4) + (double)height3 / 2.0), (double)((double)height3 / 3.0));
            GL11.glVertex2d((double)((double)maxWidth + 2.5 + (double)height3 / 3.0), (double)(2.0 * (double)height3 / 3.0));
            GL11.glVertex2d((double)((double)maxWidth + 5.5 + 2.0 * (double)height3 / 3.0), (double)(2.0 * (double)height3 / 3.0));
        } else {
            GL11.glVertex2d((double)((double)maxWidth + 2.5 + (double)height3 / 3.0), (double)((double)height3 / 3.0));
            GL11.glVertex2d((double)((double)maxWidth + 5.5 + 2.0 * (double)height3 / 3.0), (double)((double)height3 / 3.0));
            GL11.glVertex2d((double)((double)(maxWidth + 4) + (double)height3 / 2.0), (double)(2.0 * (double)height3 / 3.0));
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
        String text = component.getSelectedElement();
        this.theme.getFontRenderer().b(text, 2, area.height / 2 - this.theme.getFontRenderer().a / 2, RenderUtil.toRGBA(component.getForegroundColor()));
        if (component.isSelected()) {
            int offset = area.height + 2;
            String[] elements3 = component.getElements();
            for (int i4 = 0; i4 < elements3.length; ++i4) {
                if (i4 == component.getSelectedIndex()) continue;
                this.theme.getFontRenderer().b(elements3[i4], (area.width - this.theme.getFontRenderer().a(elements3[i4])) / 2, offset, RenderUtil.toRGBA(component.getForegroundColor()));
                offset += this.theme.getFontRenderer().a + 2;
            }
        }
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        this.translateComponent(component, true);
    }

    @Override
    protected Dimension getDefaultComponentSize(ComboBox component) {
        int maxWidth = 0;
        for (String element : component.getElements()) {
            maxWidth = Math.max(maxWidth, this.theme.getFontRenderer().a(element));
        }
        return new Dimension(maxWidth + 8 + this.theme.getFontRenderer().a, this.theme.getFontRenderer().a + 4);
    }

    @Override
    protected Rectangle[] getInteractableComponentRegions(ComboBox component) {
        int height = component.getHeight();
        if (component.isSelected()) {
            String[] elements = component.getElements();
            for (int i2 = 0; i2 < elements.length; ++i2) {
                height += this.theme.getFontRenderer().a + 2;
            }
            height += 2;
        }
        return new Rectangle[]{new Rectangle(0, 0, component.getWidth(), height)};
    }

    @Override
    protected void handleComponentInteraction(ComboBox component, Point location, int button) {
        if (button != 0) {
            return;
        }
        if (location.x <= component.getWidth() && location.y <= component.getHeight()) {
            component.setSelected(!component.isSelected());
        } else if (location.x <= component.getWidth() && component.isSelected()) {
            int offset = component.getHeight() + 2;
            String[] elements = component.getElements();
            for (int i2 = 0; i2 < elements.length; ++i2) {
                if (i2 == component.getSelectedIndex()) continue;
                if (location.y >= offset && location.y <= offset + this.theme.getFontRenderer().a) {
                    component.setSelectedIndex(i2);
                    component.setSelected(false);
                    break;
                }
                offset += this.theme.getFontRenderer().a + 2;
            }
        }
    }
}

