/*
 * Decompiled with CFR 0.152.
 */
package org.darkstorm.minecraft.gui.theme.wurst;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.darkstorm.minecraft.gui.component.Label;
import org.darkstorm.minecraft.gui.theme.AbstractComponentUI;
import org.darkstorm.minecraft.gui.theme.wurst.WurstTheme;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.opengl.GL11;

public class WurstLabelUI
extends AbstractComponentUI<Label> {
    private final WurstTheme theme;

    WurstLabelUI(WurstTheme theme) {
        super(Label.class);
        this.theme = theme;
        this.foreground = Color.WHITE;
        this.background = new Color(64, 64, 64, 192);
    }

    @Override
    protected void renderComponent(Label label) {
        this.translateComponent(label, false);
        Rectangle area = label.getArea();
        int x2 = 0;
        int y2 = 0;
        switch (label.getHorizontalAlignment()) {
            case CENTER: {
                x2 += label.getWidth() / 2 - this.theme.getFontRenderer().a(label.getText()) / 2;
                break;
            }
            case RIGHT: {
                x2 += label.getWidth() - this.theme.getFontRenderer().a(label.getText()) - 2;
                break;
            }
            default: {
                x2 += 2;
            }
        }
        switch (label.getVerticalAlignment()) {
            case TOP: {
                y2 += 2;
                break;
            }
            case BOTTOM: {
                y2 += label.getHeight() - this.theme.getFontRenderer().a - 2;
                break;
            }
            default: {
                y2 += label.getHeight() / 2 - this.theme.getFontRenderer().a / 2;
            }
        }
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2884);
        this.theme.getFontRenderer().b(label.getText(), x2, y2, RenderUtil.toRGBA(label.getForegroundColor()));
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        this.translateComponent(label, true);
    }

    @Override
    protected Dimension getDefaultComponentSize(Label component) {
        return new Dimension(this.theme.getFontRenderer().a(component.getText()) + 4, this.theme.getFontRenderer().a + 4);
    }
}

