/*
 * Decompiled with CFR 0.152.
 */
package org.darkstorm.minecraft.gui.theme.wurst;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.darkstorm.minecraft.gui.component.Component;
import org.darkstorm.minecraft.gui.component.Panel;
import org.darkstorm.minecraft.gui.layout.Constraint;
import org.darkstorm.minecraft.gui.theme.AbstractComponentUI;
import org.darkstorm.minecraft.gui.theme.wurst.WurstTheme;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.opengl.GL11;

public class WurstPanelUI
extends AbstractComponentUI<Panel> {
    private final WurstTheme theme;

    WurstPanelUI(WurstTheme theme) {
        super(Panel.class);
        this.theme = theme;
        this.foreground = Color.WHITE;
        this.background = new Color(128, 128, 128, 128);
    }

    @Override
    protected void renderComponent(Panel component) {
        if (component.getParent() != null) {
            return;
        }
        Rectangle area = component.getArea();
        this.translateComponent(component, false);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2884);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtil.setColor(component.getBackgroundColor());
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)0.0, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)0.0);
        GL11.glVertex2d((double)area.width, (double)area.height);
        GL11.glVertex2d((double)0.0, (double)area.height);
        GL11.glEnd();
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        this.translateComponent(component, true);
    }

    @Override
    protected Dimension getDefaultComponentSize(Panel component) {
        Component[] children = component.getChildren();
        Rectangle[] areas = new Rectangle[children.length];
        Constraint[][] constraints = new Constraint[children.length][];
        for (int i2 = 0; i2 < children.length; ++i2) {
            Component child = children[i2];
            Dimension size = child.getTheme().getUIForComponent(child).getDefaultSize(child);
            areas[i2] = new Rectangle(0, 0, size.width, size.height);
            constraints[i2] = component.getConstraints(child);
        }
        return component.getLayoutManager().getOptimalPositionedSize(areas, constraints);
    }
}

