/*
 * Decompiled with CFR 0.152.
 */
package org.darkstorm.minecraft.gui.util;

import java.awt.Color;
import java.awt.Point;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class RenderUtil {
    public static void scissorBox(int x2, int y2, int xend, int yend) {
        int width = xend - x2;
        int height = yend - y2;
        bam sr2 = new bam(azd.A().u, azd.A().d, azd.A().e);
        int factor = sr2.e();
        int bottomY = azd.A().n.m - yend;
        GL11.glScissor((int)(x2 * factor), (int)(bottomY * factor), (int)(width * factor), (int)(height * factor));
    }

    public static void setupLineSmooth() {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)2848);
        GL11.glDisable((int)3553);
        GL11.glHint((int)3154, (int)4354);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)32925);
        GL11.glEnable((int)32926);
        GL11.glShadeModel((int)7425);
    }

    public static void drawLine(double startX, double startY, double startZ, double endX, double endY, double endZ, float thickness) {
        GL11.glPushMatrix();
        RenderUtil.setupLineSmooth();
        GL11.glLineWidth((float)thickness);
        GL11.glBegin((int)1);
        GL11.glVertex3d((double)startX, (double)startY, (double)startZ);
        GL11.glVertex3d((double)endX, (double)endY, (double)endZ);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2848);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glDisable((int)32925);
        GL11.glDisable((int)32926);
        GL11.glPopMatrix();
    }

    public static void drawTexturedModalRect(int par1, int par2, int par3, int par4, int par5, int par6) {
        float var7 = 0.00390625f;
        float var8 = 0.00390625f;
        blz var9 = blz.a;
        var9.b();
        var9.a(par1 + 0, par2 + par6, 0.0, (float)(par3 + 0) * var7, (float)(par4 + par6) * var8);
        var9.a(par1 + par5, par2 + par6, 0.0, (float)(par3 + par5) * var7, (float)(par4 + par6) * var8);
        var9.a(par1 + par5, par2 + 0, 0.0, (float)(par3 + par5) * var7, (float)(par4 + 0) * var8);
        var9.a(par1 + 0, par2 + 0, 0.0, (float)(par3 + 0) * var7, (float)(par4 + 0) * var8);
        var9.a();
    }

    public static void drawTexturedModalRect(int textureId, int posX, int posY, int width, int height) {
        double halfHeight = height / 2;
        double halfWidth = width / 2;
        GL11.glDisable((int)2884);
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)posX + halfWidth), (double)((double)posY + halfHeight), (double)0.0);
        GL11.glScalef((float)width, (float)height, (float)0.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)4);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2d((double)1.0, (double)1.0);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex2d((double)-1.0, (double)1.0);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2d((double)-1.0, (double)-1.0);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2d((double)-1.0, (double)-1.0);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex2d((double)1.0, (double)-1.0);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex2d((double)1.0, (double)1.0);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glBindTexture((int)3553, (int)0);
        GL11.glPopMatrix();
    }

    public static int interpolateColor(int rgba1, int rgba2, float percent) {
        int r1 = rgba1 & 0xFF;
        int g1 = rgba1 >> 8 & 0xFF;
        int b1 = rgba1 >> 16 & 0xFF;
        int a1 = rgba1 >> 24 & 0xFF;
        int r2 = rgba2 & 0xFF;
        int g2 = rgba2 >> 8 & 0xFF;
        int b2 = rgba2 >> 16 & 0xFF;
        int a2 = rgba2 >> 24 & 0xFF;
        int r3 = (int)(r1 < r2 ? (float)r1 + (float)(r2 - r1) * percent : (float)r2 + (float)(r1 - r2) * percent);
        int g3 = (int)(g1 < g2 ? (float)g1 + (float)(g2 - g1) * percent : (float)g2 + (float)(g1 - g2) * percent);
        int b3 = (int)(b1 < b2 ? (float)b1 + (float)(b2 - b1) * percent : (float)b2 + (float)(b1 - b2) * percent);
        int a3 = (int)(a1 < a2 ? (float)a1 + (float)(a2 - a1) * percent : (float)a2 + (float)(a1 - a2) * percent);
        return r3 | g3 << 8 | b3 << 16 | a3 << 24;
    }

    public static void setColor(Color c2) {
        GL11.glColor4f((float)((float)c2.getRed() / 255.0f), (float)((float)c2.getGreen() / 255.0f), (float)((float)c2.getBlue() / 255.0f), (float)((float)c2.getAlpha() / 255.0f));
    }

    public static Color toColor(int rgba) {
        int r2 = rgba & 0xFF;
        int g2 = rgba >> 8 & 0xFF;
        int b2 = rgba >> 16 & 0xFF;
        int a2 = rgba >> 24 & 0xFF;
        return new Color(r2, g2, b2, a2);
    }

    public static int toRGBA(Color c2) {
        return c2.getRed() | c2.getGreen() << 8 | c2.getBlue() << 16 | c2.getAlpha() << 24;
    }

    public static void setColor(int rgba) {
        int r2 = rgba & 0xFF;
        int g2 = rgba >> 8 & 0xFF;
        int b2 = rgba >> 16 & 0xFF;
        int a2 = rgba >> 24 & 0xFF;
        GL11.glColor4b((byte)((byte)r2), (byte)((byte)g2), (byte)((byte)b2), (byte)((byte)a2));
    }

    public static Point calculateMouseLocation() {
        int scaleFactor;
        azd minecraft = azd.A();
        int scale = minecraft.u.at;
        if (scale == 0) {
            scale = 1000;
        }
        for (scaleFactor = 0; scaleFactor < scale && minecraft.d / (scaleFactor + 1) >= 320 && minecraft.e / (scaleFactor + 1) >= 240; ++scaleFactor) {
        }
        return new Point(Mouse.getX() / scaleFactor, minecraft.e / scaleFactor - Mouse.getY() / scaleFactor - 1);
    }
}

