/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick.openal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.lwjgl.LWJGLUtil;

public class AiffData {
    public final ByteBuffer data;
    public final int format;
    public final int samplerate;

    private AiffData(ByteBuffer data, int format, int samplerate) {
        this.data = data;
        this.format = format;
        this.samplerate = samplerate;
    }

    public void dispose() {
        this.data.clear();
    }

    public static AiffData create(URL path) {
        try {
            return AiffData.create(AudioSystem.getAudioInputStream(new BufferedInputStream(path.openStream())));
        }
        catch (Exception e2) {
            LWJGLUtil.log((CharSequence)("Unable to create from: " + path));
            e2.printStackTrace();
            return null;
        }
    }

    public static AiffData create(String path) {
        return AiffData.create(AiffData.class.getClassLoader().getResource(path));
    }

    public static AiffData create(InputStream is2) {
        try {
            return AiffData.create(AudioSystem.getAudioInputStream(is2));
        }
        catch (Exception e2) {
            LWJGLUtil.log((CharSequence)"Unable to create from inputstream");
            e2.printStackTrace();
            return null;
        }
    }

    public static AiffData create(byte[] buffer) {
        try {
            return AiffData.create(AudioSystem.getAudioInputStream(new BufferedInputStream(new ByteArrayInputStream(buffer))));
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static AiffData create(ByteBuffer buffer) {
        try {
            byte[] bytes = null;
            if (buffer.hasArray()) {
                bytes = buffer.array();
            } else {
                bytes = new byte[buffer.capacity()];
                buffer.get(bytes);
            }
            return AiffData.create(bytes);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AiffData create(AudioInputStream ais2) {
        AudioFormat audioformat = ais2.getFormat();
        int channels = 0;
        if (audioformat.getChannels() == 1) {
            if (audioformat.getSampleSizeInBits() == 8) {
                channels = 4352;
            } else {
                if (audioformat.getSampleSizeInBits() != 16) throw new RuntimeException("Illegal sample size");
                channels = 4353;
            }
        } else {
            if (audioformat.getChannels() != 2) throw new RuntimeException("Only mono or stereo is supported");
            if (audioformat.getSampleSizeInBits() == 8) {
                channels = 4354;
            } else {
                if (audioformat.getSampleSizeInBits() != 16) throw new RuntimeException("Illegal sample size");
                channels = 4355;
            }
        }
        byte[] buf2 = new byte[audioformat.getChannels() * (int)ais2.getFrameLength() * audioformat.getSampleSizeInBits() / 8];
        int read = 0;
        try {
            for (int total = 0; (read = ais2.read(buf2, total, buf2.length - total)) != -1 && total < buf2.length; total += read) {
            }
        }
        catch (IOException ioe) {
            return null;
        }
        ByteBuffer buffer = AiffData.convertAudioBytes(audioformat, buf2, audioformat.getSampleSizeInBits() == 16);
        AiffData Aiffdata = new AiffData(buffer, channels, (int)audioformat.getSampleRate());
        try {
            ais2.close();
            return Aiffdata;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return Aiffdata;
    }

    private static ByteBuffer convertAudioBytes(AudioFormat format, byte[] audio_bytes, boolean two_bytes_data) {
        ByteBuffer dest = ByteBuffer.allocateDirect(audio_bytes.length);
        dest.order(ByteOrder.nativeOrder());
        ByteBuffer src = ByteBuffer.wrap(audio_bytes);
        src.order(ByteOrder.BIG_ENDIAN);
        if (two_bytes_data) {
            ShortBuffer dest_short = dest.asShortBuffer();
            ShortBuffer src_short = src.asShortBuffer();
            while (src_short.hasRemaining()) {
                dest_short.put(src_short.get());
            }
        } else {
            while (src.hasRemaining()) {
                byte b2 = src.get();
                if (format.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
                    b2 = (byte)(b2 + 127);
                }
                dest.put(b2);
            }
        }
        dest.rewind();
        return dest;
    }
}

